/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.dlink;

import java.util.ArrayList;
import ru.bitel.bgbilling.modules.ipn.server.DlinkGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Rule;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.varbind;

public class IPRule
extends Rule {
    private String OID;
    private String OID_TYPE;
    private String OID_SRC_IP;
    private String OID_DST_IP;
    private String OID_PORT;
    private String OID_DST_PORT;
    private String OID_MANAGE;
    public static final int MANAGE_DELETE = 6;
    public static final int MANAGE_CREATE = 4;
    public static final int TYPE_PERMIT = 2;
    public static final int TYPE_DENY = 1;
    public static final int PROTO_NONE = 1;
    public static final int PROTO_UDP = 5;
    private String srcMask;
    private String dstMask;
    private int dstPort;
    private int type;

    public static final String getOid(int model) {
        String OID = null;
        switch (model) {
            case 1: {
                OID = "1.3.6.1.4.1.171.12.9.2.2.1";
                break;
            }
            case 2: {
                OID = "1.3.6.1.4.1.171.12.9.3.2.1";
            }
        }
        return OID;
    }

    public IPRule(int model) {
        this.OID = IPRule.getOid(model);
        this.OID_TYPE = this.OID + ".20";
        this.OID_SRC_IP = this.OID + ".4";
        this.OID_DST_IP = this.OID + ".5";
        this.OID_PORT = this.OID + ".21";
        this.OID_DST_PORT = this.OID + ".11";
        this.OID_MANAGE = this.OID + ".22";
    }

    public IPRule(int model, int id, int port, int type, String srcMask, String dstMask, int proto, int dstPort) {
        this(model);
        this.id = id;
        this.port = port;
        this.type = type;
        this.srcMask = srcMask;
        this.dstMask = dstMask;
        this.dstPort = dstPort;
    }

    @Override
    public void takeData(PortMask pm, String oid, varbind var) {
        if (oid.startsWith(this.OID_PORT)) {
            AsnOctets val = (AsnOctets)var.getValue();
            this.port = pm.maskToPort(val.getBytes());
        } else if (oid.startsWith(this.OID_SRC_IP)) {
            AsnOctets octets = (AsnOctets)var.getValue();
            this.srcMask = Utils.bytesToString((byte[])octets.getBytes());
        } else if (oid.startsWith(this.OID_DST_IP)) {
            AsnOctets octets = (AsnOctets)var.getValue();
            this.dstMask = Utils.bytesToString((byte[])octets.getBytes());
        } else if (oid.startsWith(this.OID_DST_PORT)) {
            AsnInteger octets = (AsnInteger)var.getValue();
            this.dstPort = octets.getValue();
        }
    }

    @Override
    public void createRule(int profile, DlinkGateWorker gateWorker, PortMask pm) throws Exception {
        String id = profile + "." + this.id;
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(5);
        String oid = null;
        oid = this.OID_SRC_IP + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.srcMask), 64)});
        oid = this.OID_DST_IP + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.dstMask), 64)});
        oid = this.OID_TYPE + "." + id;
        pairs.add(new Object[]{oid, new AsnInteger(this.type)});
        oid = this.OID_PORT + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(pm.portToMask(this.port))});
        oid = this.OID_DST_PORT + "." + id;
        pairs.add(new Object[]{oid, new AsnInteger(this.dstPort)});
        oid = this.OID_MANAGE + "." + id;
        pairs.add(new Object[]{oid, new AsnInteger(4)});
        gateWorker.sendSetPdu(pairs);
    }

    @Override
    public void deleteRule(int profile, DlinkGateWorker gateWorker) throws Exception {
        String oid = this.OID_MANAGE + "." + profile + "." + this.id;
        gateWorker.sendSetPdu(oid, (AsnObject)new AsnInteger(6));
    }
}

