/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.function.server.action.pub;

import bitel.billing.server.ActionResultContentType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebContractSearchModule;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.function.server.access_restore.RestoreAbstract;
import ru.bitel.bgbilling.kernel.contract.function.server.action.pub.BaseAction;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.AccessRestoreStepData;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ActionAccessRestore
extends BaseAction {
    private static List<RestoreAbstract> restoreModes = null;

    public void doHintSearch() {
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        JSONObject addressJson = new JSONObject().put("contractId", 1).put("houseId", 1).put("address", (Object)"443099. \u0433. \u0421\u0430\u043c\u0430\u0440\u0430, \u0443\u043b. \u0410\u043b\u0435\u043a\u0441\u0435\u044f \u0422\u043e\u043b\u0441\u0442\u043e\u0433\u043e, \u0434. 87, \u043a\u043e\u043c. 31");
        array.put((Object)addressJson);
        addressJson = new JSONObject().put("contractId", 1).put("houseId", 1).put("address", (Object)"443099. \u0433. \u0421\u0430\u043c\u0430\u0440\u0430, \u0443\u043b. \u0410\u043b\u0435\u043a\u0441\u0435\u044f \u0422\u043e\u043b\u0441\u0442\u043e\u0433\u043e, \u0434. 87, \u043a\u043e\u043c. 32");
        array.put((Object)addressJson);
        jsonObject.put("result", (Object)array);
        this.setResultParam("contentType", ActionResultContentType.json.toString());
        this.setResultParam("json", jsonObject);
    }

    @Override
    public void execute() throws Exception {
        String paramContract = this.req.get("contract");
        String paramButton = this.req.get("button", "restore");
        this.setResultParam("pageTitle", "\u0412\u043ec\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u041b\u041a");
        this.setResultParam("jspPage", "contract/password_restore.jsp");
        this.setResultParam("userName", paramContract);
        this.setResultParam("buttonSelectKey", paramButton);
        this.setResultParam("contentType", ActionResultContentType.jsp.toString());
        if (this.context.getRequest().getSession().getAttribute("searchModules") == null) {
            ArrayList<KeyValue> searchModules = new ArrayList<KeyValue>();
            DynamicCodeDao dynamicCodeDao = new DynamicCodeDao(this.con);
            List<String> classesName = dynamicCodeDao.getActualClassesByInterface(WebContractSearchModule.class.getName());
            for (String className : classesName) {
                WebContractSearchModule webContractSearchModule = DynamicClassManager.getInstance().newInstance(WebContractSearchModule.class, className);
                webContractSearchModule.init(this.con);
                if (!webContractSearchModule.useForAccessRestore()) continue;
                searchModules.add(new KeyValue(className, webContractSearchModule.getTitle()));
            }
            this.context.getRequest().getSession().setAttribute("searchModules", searchModules);
        }
        if (!"restore".equals(paramButton)) {
            this.doSearchContract(paramButton);
        }
        if (paramContract != null) {
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                contract = contractDao.getByTitle(paramContract);
                if (contract == null) {
                    this.setError("contractNotFound");
                    return;
                }
            }
            List<RestoreAbstract> restoreModes = ActionAccessRestore.getRestoreModes();
            if (restoreModes.isEmpty()) {
                this.setError("restoreModesEmpty");
                return;
            }
            this.setResultParam("restoreModes", restoreModes);
            String paramRestoreMode = this.req.get("restoreMode", restoreModes.get(0).getModeName());
            for (RestoreAbstract restoreMode : restoreModes) {
                if (!restoreMode.getModeName().equals(paramRestoreMode)) continue;
                AccessRestoreStepData accessRestoreStepData = restoreMode.doStep(this.req, contract, this.con);
                this.setResultParam("restoreModeData", accessRestoreStepData);
                if (accessRestoreStepData.getErrorMessage() == null) continue;
                this.setError(accessRestoreStepData.getErrorMessage());
            }
            this.setResultParam("restoreMode", paramRestoreMode);
        }
    }

    private static List<RestoreAbstract> getRestoreModes() {
        if (restoreModes == null) {
            List<RestoreAbstract> modes = new ArrayList<RestoreAbstract>();
            for (Class<?> clazz : Utils.getClassList(RestoreAbstract.class.getPackageName())) {
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                try {
                    RestoreAbstract restoreMode;
                    Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(obj instanceof RestoreAbstract) || !(restoreMode = (RestoreAbstract)obj).isEnaled()) continue;
                    modes.add(restoreMode);
                }
                catch (Exception restoreMode) {}
            }
            ArrayList<RestoreAbstract> orderModes = new ArrayList<RestoreAbstract>();
            for (String mode : Utils.toList(Setup.getSetup().get("web.contract.access.restore.mode.order", "email,sms"))) {
                modes.stream().filter(a -> a.getModeName().equals(mode)).findFirst().ifPresent(a -> orderModes.add((RestoreAbstract)a));
                modes = modes.stream().filter(a -> !a.getModeName().equals(mode)).toList();
            }
            orderModes.addAll(modes);
            restoreModes = orderModes;
        }
        return restoreModes;
    }
}

