/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ObjectTypeManager {
    private Connection con;
    private static final String TABLE_NAME = "object_type";
    private static final String TABLE_NAME_MODULE = "object_type_module";

    public ObjectTypeManager(Connection con) {
        this.con = con;
    }

    public Map<Integer, ObjectType> getTypeMap() {
        HashMap<Integer, ObjectType> result = new HashMap<Integer, ObjectType>();
        try {
            String query = "SELECT * FROM object_type";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ObjectType type = this.getTypeFromRs(rs);
                result.put(type.getId(), type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ObjectType> getTypeList(boolean onlyVisible) throws BGException {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        String query = "SELECT * FROM object_type" + (onlyVisible ? " WHERE ishidden=0" : "") + " ORDER BY `title`";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public ObjectType getType(int id) throws BGException {
        ObjectType result = null;
        String query = "SELECT * FROM object_type WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getTypeFromRs(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public int updateType(ObjectType type) throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO object_type (title, name_macros, comment, ishidden) VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE object_type SET title=?, name_macros=?, comment=?, ishidden=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setString(2, type.getNameMakros());
            ps.setString(3, type.getComment());
            ps.setBoolean(4, type.isHidden());
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
            this.deleteTypeModules(type.getId());
            if (Utils.notEmptyCollection(type.getModuleList())) {
                query = "INSERT INTO object_type_module SET type_id=?, mid=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, type.getId());
                for (Integer mid : type.getModuleList()) {
                    ps.setInt(2, mid);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return type.getId();
    }

    public void deleteType(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM object_type WHERE id=?");){
            ps.setInt(1, id);
            ps.executeUpdate();
            this.deleteTypeModules(id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void deleteTypeModules(int id) throws SQLException {
        String query = "DELETE FROM object_type_module WHERE type_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    private ObjectType getTypeFromRs(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        return ObjectType.builder().setId(id).setTitle(rs.getString("title")).setNameMakros(rs.getString("name_macros")).setComment(rs.getString("comment")).setHidden(rs.getBoolean("ishidden")).setModuleList(this.getModuleListByType(id)).build();
    }

    private List<Integer> getModuleListByType(int typeId) throws SQLException {
        ArrayList<Integer> moduleList = new ArrayList<Integer>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT mid FROM object_type_module WHERE type_id=?");){
            ps.setInt(1, typeId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    moduleList.add(rs.getInt(1));
                }
            }
        }
        return moduleList;
    }
}

