/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.config.server.bean;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.AbstractContractConfig;
import ru.bitel.common.Utils;

public class ContractModuleConfigDao
extends AbstractContractConfig {
    public ContractModuleConfigDao(Connection con, int moduleId) {
        super("contract_module_config", con, moduleId);
    }

    public static String getPaymentEmail(Connection con, int moduleId, int contractId) throws BGException {
        String result;
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(con, moduleId);){
            result = Utils.normalizeEmail(contractModuleConfigDao.get(contractId, "customerEmail"));
            if (Utils.notBlankString(result)) {
                String string = result;
                return string;
            }
            result = contractModuleConfigDao.get(contractId, "customerAddress");
            if (Utils.notBlankString(result) && result.contains("@") && Utils.notBlankString(result = Utils.normalizeEmail(result))) {
                String string = result;
                return string;
            }
        }
        contractModuleConfigDao = new ContractModuleConfigDao(con, 0);
        try {
            result = Utils.normalizeEmail(contractModuleConfigDao.get(contractId, "payment.email"));
            if (Utils.notBlankString(result)) {
                String string = result;
                return string;
            }
        }
        finally {
            contractModuleConfigDao.close();
        }
        return "";
    }

    public static String getPaymentPhone(Connection con, int moduleId, int contractId) throws BGException {
        String result;
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(con, moduleId);){
            result = contractModuleConfigDao.get(contractId, "customerAddress");
            if (Utils.notBlankString(result) && !result.contains("@") && Utils.notBlankString(result = Utils.normalizePhone(result))) {
                String string = result;
                return string;
            }
        }
        contractModuleConfigDao = new ContractModuleConfigDao(con, 0);
        try {
            result = Utils.normalizePhone(contractModuleConfigDao.get(contractId, "payment.phone"));
            if (Utils.notBlankString(result)) {
                String string = result;
                return string;
            }
        }
        finally {
            contractModuleConfigDao.close();
        }
        return "";
    }

    public static String getPaymentCheckAddress(Connection con, int moduleId, int contractId) throws BGException {
        String result;
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(con, moduleId);){
            result = Utils.normalizeEmail(contractModuleConfigDao.get(contractId, "customerEmail"));
            if (Utils.notBlankString(result) && result.contains("@")) {
                String string = result;
                return string;
            }
            result = contractModuleConfigDao.get(contractId, "customerAddress");
            if (Utils.notBlankString(result)) {
                String string = result = result.contains("@") ? Utils.normalizeEmail(result) : Utils.normalizePhone(result);
                if (Utils.notBlankString(result)) {
                    String string2 = result;
                    return string2;
                }
            }
        }
        contractModuleConfigDao = new ContractModuleConfigDao(con, 0);
        try {
            result = Utils.normalizeEmail(contractModuleConfigDao.get(contractId, "payment.email"));
            if (Utils.notBlankString(result)) {
                String string = result;
                return string;
            }
            result = Utils.normalizePhone(contractModuleConfigDao.get(contractId, "payment.phone"));
            if (Utils.notBlankString(result)) {
                String string = result;
                return string;
            }
        }
        finally {
            contractModuleConfigDao.close();
        }
        return "";
    }
}

