/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGLoggedEditor;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.LogRequestParameters;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.cerbercrypt.client.UserCardFilterPanel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCardCopy;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardCopyService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class UserCardCopyPanel
extends BGUPanel {
    private BGLoggedEditor editor;
    private UserCardCopyEditor copyEditor = new UserCardCopyEditor();
    private BGUTable table;
    private BGTableModel<UserCardCopy> model;
    private UserCardFilterPanel filterPanel = new UserCardFilterPanel(this);

    protected void jbInit() {
        this.model = new BGTableModel<UserCardCopy>("userCardCopy"){

            protected void initColumns() {
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 150, 150, -1, "period", true);
                this.addColumn("\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430", 150, 150, -1, "number", true);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 150, 150, -1, "comment", true);
            }

            public Object getValue(UserCardCopy val, int column) throws Exception {
                if (column == 0) {
                    return TimeUtils.formatPeriod((Date)val.getDate1(), (Date)val.getDate2());
                }
                if (column == 1) {
                    UserCard userCard = val.getParentCard();
                    return userCard == null ? "?" : userCard.getGuiTitle();
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.editor = new BGLoggedEditor("def", UserCardCopyService.class);
        this.editor.addForm((JComponent)((Object)this.copyEditor), new LogRequestParameters(){

            public Object[] getArgs() {
                return new Object[]{UserCardCopyPanel.this.copyEditor.current.getId()};
            }

            public String getFilter() {
                return "oid";
            }
        });
        this.editor.addEmptyForm("def", new LogRequestParameters(){

            public String getFilter() {
                return "cid";
            }

            public Object[] getArgs() {
                return new Object[]{0};
            }
        });
        this.editor.show("def");
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.filterPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (BGUPanel)this, (String)"edit");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.filterPanel.refresh();
            UserCard cardItem = (UserCard)this.filterPanel.getCardFilterCB().getSelectedItem();
            Integer uid = cardItem != null ? cardItem.getId() : -1;
            LocalDate dateCalendar = this.filterPanel.getDateFilter().getLocalDate();
            this.model.setData(((UserCardCopyService)((ClientContext)this.getContext()).getPort(UserCardCopyService.class)).getUserCardCopyList(uid.intValue(), dateCalendar));
        });
    }

    class UserCardCopyEditor
    extends BGUPanel {
        protected UserCardCopy current;
        private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
        private JTextArea commentTA = new JTextArea();
        private JLabel label = new JLabel();

        UserCardCopyEditor() {
        }

        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.commentTA.setLineWrap(true);
            this.commentTA.setWrapStyleWord(true);
            JPanel panel1 = new JPanel(new GridBagLayout());
            panel1.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
            leftPanel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            leftPanel.add((Component)panel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            leftPanel.add(Box.createGlue(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            JPanel rightPanel = new JPanel(new GridBagLayout());
            rightPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
            rightPanel.add((Component)new JScrollPane(this.commentTA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add(leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(rightPanel, new GridBagConstraints(1, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                UserCard parentId = (UserCard)UserCardCopyPanel.this.filterPanel.getCardFilterCB().getSelectedItem();
                if (parentId == null || parentId.getId() <= 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443!");
                    return;
                }
                this.current = new UserCardCopy();
                this.current.setId(-1);
                this.current.setParentCardId(parentId.getId());
                this.label.setText(parentId.getGuiTitle());
                this.commentTA.setText("");
                this.periodPanel.setDateString2("");
                this.periodPanel.setDateCalendar1((Calendar)new GregorianCalendar());
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (UserCardCopy)UserCardCopyPanel.this.model.getSelectedRow();
                if (this.current != null) {
                    this.label.setText(" " + this.current.getParentCard().getGuiTitle());
                    this.periodPanel.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)this.current.getDate1()));
                    this.periodPanel.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)this.current.getDate2()));
                    this.commentTA.setText(this.current.getComment());
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (UserCardCopy)UserCardCopyPanel.this.model.getSelectedRow();
                if (this.current != null && this.current.getId() >= 0 && BGSwingUtilites.confirmDelete((Object)this.current)) {
                    ((UserCardCopyService)((ClientContext)this.getContext()).getPort(UserCardCopyService.class)).deleteUserCardCopy(this.current.getId());
                    UserCardCopyPanel.this.model.deleteRow((Object)this.current);
                    this.performActionClose();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (UserCardCopyEditor.this.current != null) {
                        if (Utils.isEmptyString((String)UserCardCopyEditor.this.periodPanel.getDateString1())) {
                            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                            return;
                        }
                        if (TimeUtils.dateBefore((Calendar)UserCardCopyEditor.this.periodPanel.getDateCalendar2(), (Calendar)UserCardCopyEditor.this.periodPanel.getDateCalendar1())) {
                            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b \u043e\u0448\u0438\u0431\u043b\u0438\u0441\u044c! \u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0435\u0433\u043e \u043d\u0430\u0447\u0430\u043b\u0430!");
                            return;
                        }
                        UserCardCopy ucc = new UserCardCopy();
                        ucc.setId(UserCardCopyEditor.this.current.getId());
                        ucc.setParentCardId(UserCardCopyEditor.this.current.getParentCardId());
                        ucc.setDate1(UserCardCopyEditor.this.periodPanel.getDateFrom());
                        ucc.setDate2(UserCardCopyEditor.this.periodPanel.getDateTo());
                        ucc.setComment(UserCardCopyEditor.this.commentTA.getText());
                        ((UserCardCopyService)((ClientContext)UserCardCopyEditor.this.getContext()).getPort(UserCardCopyService.class)).updateUserCardCopy(ucc);
                        UserCardCopyPanel.this.performAction("refresh");
                        UserCardCopyEditor.this.performActionClose();
                    }
                }
            };
        }
    }
}

