/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.common.service;

import jakarta.activation.DataHandler;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;
import jakarta.xml.ws.soap.MTOM;
import java.util.List;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContractContact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService
@MTOM
@XmlSeeAlso(value={Preferences.class, DispatchMessageStatistic.class, DispatchCondition.class})
public interface DispatchService {
    @WebMethod
    public List<Dispatch> getDispatchList() throws Exception;

    @WebMethod
    public List<DispatchMessage> getMessageList(@WebParam(name="dispatchId") int var1, @WebParam(name="onlyNotSent") boolean var2) throws Exception;

    @WebMethod
    public void updateDispatch(@WebParam(name="dispatch") Dispatch var1) throws Exception;

    @WebMethod
    public void updateMessage(@WebParam(name="dispatchMessage") DispatchMessage var1) throws Exception;

    @WebMethod
    public List<BGServerFile> getMessageInclusions(@WebParam(name="dispatchMessage") DispatchMessage var1) throws Exception;

    @WebMethod
    public void addMessageInclusion(@WebParam(name="dispatchMessage") DispatchMessage var1, Holder<DataHandler> var2, @WebParam(name="fileName") String var3) throws Exception;

    @WebMethod
    public void deleteMessageInclusion(@WebParam(name="dispatchMessage") DispatchMessage var1, BGServerFile var2) throws Exception;

    @WebMethod
    public void deleteDispatch(@WebParam(name="dispatch") Dispatch var1) throws Exception;

    @WebMethod
    public void deleteMessage(@WebParam(name="dispatchMessage") DispatchMessage var1) throws Exception;

    @WebMethod
    public void updateContactType(ContactType var1) throws Exception;

    @WebMethod
    public void deleteContactType(@WebParam(name="contactTypeId") int var1) throws Exception;

    @WebMethod
    public List<ContactType> getContactTypes() throws Exception;

    @WebMethod(operationName="getContactsOld")
    @RequestWrapper(className="ru.bitel.bgbilling.plugins.dispatch.common.jaxws.GetContactsOldRequest")
    @ResponseWrapper(className="ru.bitel.bgbilling.plugins.dispatch.common.jaxws.GetContactsOldResponse")
    @Deprecated
    public List<Contact> getContacts(int var1) throws Exception;

    @WebMethod
    public List<Contact> getContacts(@WebParam(name="contractId") int var1, @WebParam(name="dispatch") Dispatch var2) throws Exception;

    @WebMethod
    public void updateContact(Contact var1) throws Exception;

    @WebMethod
    public void deleteContact(@WebParam(name="contactId") int var1) throws Exception;

    public String getContactDefaultValue(@WebParam(name="contactTypeId") int var1, @WebParam(name="contractId") int var2) throws Exception;

    @WebMethod
    public List<Subscription> getSubscriptions(int var1, int var2) throws Exception;

    @WebMethod
    public List<Subscription> getActiveSubscriptions(int var1) throws Exception;

    @WebMethod
    public void deleteSubscription(int var1) throws Exception;

    @WebMethod
    public void updateSubscriptions(Subscription var1) throws Exception;

    @WebMethod
    public void addSubscriptions(@WebParam(name="dispatchIds") String var1, @WebParam(name="contractIds") String var2) throws Exception;

    @WebMethod
    public List<SenderType> getSenderTypes() throws Exception;

    @WebMethod
    public String getSenderIfaceClassName();

    @WebMethod
    public void updateSenderType(SenderType var1) throws Exception;

    @WebMethod
    public void deleteSenderType(int var1) throws Exception;

    @WebMethod
    public List<IdTitle> getAddressParamList() throws Exception;

    @WebMethod
    public List<ContractContact> getContracts(String var1, int var2) throws Exception;

    @WebMethod
    public String getCustomConditionCheckerIfaceName() throws Exception;

    @WebMethod
    public void setEventForSubscription(int var1, int var2) throws Exception;

    @WebMethod
    public SearchResult<DispatchMessageStatistic> getMessageStatisticList(@WebParam(name="contractId") int var1, @WebParam(name="dispatchId") int var2, @WebParam(name="messageId") int var3, @WebParam(name="contactId") int var4, @WebParam(name="period") Period var5, @WebParam(name="page") Page var6) throws Exception;

    public List<String> installedModuleList() throws Exception;
}

