<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<div id="accountResult"></div>

<div class="tile">
	<c:forEach var="item" varStatus="status" items="${accountList}">
		<div class="flexRow" style="font-size: 0.8rem; padding-top: 10px;">
			<div style="margin-left: 0px;">
				<div class="titleFont3" style="margin: 0px 0px 10px 0px;">${item.account}@${domainMap[item.domainId]}</div>
				<div class="flexRow" style="margin-left: 10px; line-height: 1.5rem;">
					<div class="paramColor" style="width: 8rem;">Статус: <span><c:choose><c:when test="${item.status == 0}">открыт</c:when><c:otherwise>закрыт</c:otherwise></c:choose></span></div>
					<div class="paramColor">Квота(MB): <span><c:choose><c:when test="${ quota == 0 }">неограничено</c:when><c:otherwise><fmt:formatNumber value="${item.quota / 1024}" groupingUsed="true" maxFractionDigits="1" /></c:otherwise></c:choose></span></div>
				</div>
			</div>
			<div class="flexRow" style="align-content: center;">
				<div onclick="showBlock( 'emailRoot', 'changePassword', { ...emailQuery, accountId: ${item.id} } );"><img src="${pageContext.request.contextPath}/img/security.png" title="Смена пароля" class="iconButton"></div>
				<div onclick="showBlock( 'emailRoot', 'forwardList', { ...emailQuery, accountId: ${item.id} } );" style="padding-top: 5px;"><img src="${pageContext.request.contextPath}/img/forwardmail.png" title="Переадресация" class="iconButton"></div>
				<div onclick="if ( confirm('Удалить адрес?') ) { showBlock( 'accountResult', 'accountDelete', { ...emailQuery, accountId: ${item.id} } ); }"><img src="${pageContext.request.contextPath}/img/delete.png" title="Удалить адрес" class="iconButton"></div>
			</div>
         </div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>

	<bg:blockTitle marginTop="2" title="Добавить новый адрес"/>
	<form style="max-width: 30rem; margin: 0px auto;">
		<div class="mb-3">
			<label class="form-label" for="accountName">E-mail:</label>
			<div class="flexRow" style="align-items: center; min-width: 20rem;">
				<input type="text" id="accountName" name="accountName" class="form-control" style="text-align: center; "/><span style="flex-basis: 0;">@</span><select name="domain" style="flex-basis: 0;"><c:forEach var="item" items="${domains}"><option value="${item.id }">${item.name }</option></c:forEach></select>
			</div>
		</div>
		<div class="mb-3">
			<label class="form-label" for="accountPassword1">Пароль:</label>
			<input class="form-control" type="password" id="accountPassword1" name="accountPassword1"/>
		</div>
		<div class="mb-3">
			<label class="form-label" for="accountPassword2">Пароль еще раз:</label>
			<input class="form-control" type="password" id="accountPassword2" name="accountPassword2"/>
		</div>
		<div class="formButtons"><button type="submit" class="btn btn-primary"
			onclick="showBlock( 'accountResult', 'accountCreate', { ...emailQuery, accountName: this.form.accountName.value, accountPassword1: this.form.accountPassword1.value, accountPassword2: this.form.accountPassword2.value, domain: this.form.domain.value } ); return false;">Добавить адрес</button></div>
	</form>
</div>
