/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.BGBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;

public class SimpleEditor
extends BGPanel {
    private int mode;
    private String nameEditor;
    private String editor_name;
    private BGUList<BGUListItem> list = new BGUList();

    public SimpleEditor(String nameEditor, String editor_name, int mode) {
        this.nameEditor = nameEditor;
        this.editor_name = editor_name;
        this.mode = mode;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                BGUListItem li;
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (li = (BGUListItem)SimpleEditor.this.list.getSelectedValue()) != null) {
                    ClientUtils.showMessageDialog("\u041a\u043e\u0434 = " + li.getId(), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.list.setBorder(BGBorderFactory.createEmptyBorder());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SimpleEditor.this.list_mouseClicked(e);
            }
        });
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new BGTitleBorder(this.nameEditor));
        jPanel3.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request().setModule(this.module).setAction("ListDirectory").setAttribute("mode", this.mode);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.trySetDocument(doc);
        }
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        this.id = null;
        ArrayList items = new ArrayList();
        XMLUtils.selectElements(doc, "//directory/item").forEach(a -> items.add(new BGUListItem(Utils.parseInt(a.getAttribute("id")), a.getAttribute("title"))));
        this.list.setData(items);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            BGUListItem item = (BGUListItem)this.list.getSelectedValue();
            if (item == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            if (!ClientUtils.confirmDelete(item)) {
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteDirectoryItem");
            request.setAttribute("mode", this.mode);
            request.setAttribute("id", item.getId());
            if (!ClientUtils.checkStatus(this.getDocument(request))) {
                return;
            }
            this.setData();
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        }
    }

    void list_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.editItem();
        }
    }

    @Override
    public void newItem() {
        BGUListItem listItem = new BGUListItem();
        listItem.setAttribute("id", "new");
        new Editor("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 " + this.editor_name, listItem).open();
    }

    @Override
    public void editItem() {
        Optional.ofNullable((BGUListItem)this.list.getSelectedValue()).ifPresentOrElse(item -> new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 " + this.editor_name, (BGUListItem)item).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!"));
    }

    class Editor
    extends BGEditorDialog<BGUListItem> {
        private JTextField title;

        public Editor(String title, BGUListItem data) {
            super(title, data);
            this.title = new JTextField(50);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.title.setText(((BGUListItem)this.data).getGuiTitle());
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.maskNull(this.title.getText()).trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            Request request = new Request().setModule(SimpleEditor.this.module).setAction("UpdateDirectoryItem").setAttribute("mode", SimpleEditor.this.mode).setAttribute("id", ((BGUListItem)this.data).getAttribute("id")).setAttribute("title", this.title.getText().trim()).setAttribute("list", Utils.maskNull(((BGUListItem)this.data).getTitle()).trim());
            if (ClientUtils.checkStatus(SimpleEditor.this.getDocument(request))) {
                SimpleEditor.this.setData();
            }
            return true;
        }
    }
}

