/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class TreeNode<N extends TreeNode> {
    public int id;
    private N parent;
    public List<N> child = null;
    public boolean loaded = false;
    public boolean folder = false;

    public Icon getIcon() {
        return null;
    }

    public N getChild(int index) {
        return (N)(this.child != null && index < this.child.size() ? (TreeNode)this.child.get(index) : null);
    }

    public void setParent(N newParent) {
        this.parent = newParent;
    }

    public N getParent() {
        return this.parent;
    }

    public void addChild(N value) {
        if (value != null) {
            if (this.child == null) {
                this.child = new ArrayList<N>();
            }
            value.setParent((TreeNode)this);
            this.child.add(value);
        }
    }

    public void insertChilds(int pos, List<N> childs) {
        if (childs != null) {
            if (this.child == null) {
                this.child = new ArrayList<N>();
            }
            this.child.addAll(pos, childs);
            for (TreeNode n : childs) {
                n.parent = this;
            }
        }
    }

    public int removeChild(N value) {
        ((TreeNode)value).setParent(null);
        int i = 0;
        if (this.child != null) {
            Iterator<N> iter = this.child.iterator();
            while (iter.hasNext()) {
                if (value == iter.next()) {
                    iter.remove();
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void removeChilds() {
        if (this.child != null) {
            for (TreeNode n : this.child) {
                n.removeChilds();
                n.setParent(null);
            }
            this.child.clear();
        }
    }

    public int getChildCount() {
        if (this.loaded) {
            return this.child != null ? this.child.size() : 0;
        }
        return this.child != null && this.child.size() > 0 ? 1 : 0;
    }

    public Object getValueAt(int column) {
        return null;
    }

    public boolean isLeaf() {
        return this.child == null || this.child.size() == 0;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot((TreeNode)aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public void clear() {
        if (this.child != null) {
            for (TreeNode c : this.child) {
                c.setParent(null);
                c.clear();
            }
            this.child.clear();
            this.child = null;
        }
    }
}

