/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Observer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionCheckObserver;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.pdu.OneGetPdu;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;

public class SNMPNasConnectionInspectorMsRRAS
extends SNMPNasConnectionInspector {
    private static final Logger log = LogManager.getLogger();
    protected String snmp_oid_check = "1.3.6.1.4.1.76.1.18";
    protected String snmp_oid_kill = "1.3.6.1.4.1.76.1.18";

    public SNMPNasConnectionInspectorMsRRAS(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connection, ParameterMap params, NasConnectionInspector old) throws IOException {
        super(setup, nasIPAddress, secret, connection, params, old);
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> connection) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
        int ver = this.context.getVersion();
        try {
            String addressStr = this.getAddressString(session);
            OneGetPdu getPdu = new OneGetPdu((SnmpContextBasisFace)this.context);
            getPdu.addOid(this.snmp_oid_check + "." + addressStr);
            getPdu.addObserver((Observer)new SNMPNasConnectionCheckObserver(ver, connection, this));
            getPdu.send();
            session.addLogDebug("SNMP check request: oid snmp_oid_check." + addressStr);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP check request [ SNMP ver. " + ver + ", host=" + this.getHost() + ", msg=" + ex.getMessage() + " ]");
        }
    }

    private String getAddressString(DialUpSessionRealtime session) {
        long address = session.getIpAddress();
        byte[] addr = Utils.convertIntToBytes((int)address);
        StringBuffer address_str = new StringBuffer();
        for (int i = 0; i < addr.length; ++i) {
            if (address_str.length() != 0) {
                address_str.append(".");
            }
            address_str.append(Utils.unsignedByteToInt(addr[i]));
        }
        return address_str.toString();
    }

    @Override
    public long sendKillRequest(NasConnection<?> connection) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
        try {
            String address_str = this.getAddressString(session);
            SetPdu setPdu = new SetPdu((SnmpContextBasisFace)this.context);
            setPdu.addOid(this.snmp_oid_kill + "." + address_str, (AsnObject)new AsnOctets("RESET"));
            setPdu.send();
            session.addLogInfo("SNMP reset request: set snmp_oid_kill ." + address_str + " s RESET");
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP reset request [ SNMP ver." + this.context.getVersion() + ", host=" + this.getHost() + ", msg=" + ex.getMessage() + " ]");
        }
        return 0L;
    }
}

