/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlEditorService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.TextHintPopup;

public class SQLHintPopup
extends TextHintPopup {
    private final TextHintPopup.HintPopup popupWithColumns = new TextHintPopup.HintPopup((TextHintPopup)this);

    public SQLHintPopup(final JTextComponent textComponent, final SqlEditorService sqlEditorService) throws BGException {
        super(textComponent, sqlEditorService.getTableNamesList());
        this.popupWithColumns.setCustomItemListener(actionEvent -> {
            Object source = actionEvent.getSource();
            if (source instanceof JMenuItem) {
                String columnType = ((JMenuItem)source).getText();
                if (Utils.notBlankString((String)columnType) && columnType.contains("[")) {
                    columnType = columnType.substring(0, columnType.indexOf("["));
                }
                textComponent.setText(textComponent.getText() + " " + columnType);
                this.popupWithColumns.setVisible(false);
            }
        });
        textComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SQLHintPopup.this.popupWithColumns.removeAll();
                String selectedText = textComponent.getSelectedText();
                if (Utils.notBlankString((String)selectedText) && SQLHintPopup.this.data.contains(selectedText)) {
                    SQLHintPopup.this.popupWithColumns.addItems(sqlEditorService.getColumnsOfTable(selectedText).stream().map(columnWithType -> (String)columnWithType.getSecond() + " [" + (String)columnWithType.getFirst() + "]").collect(Collectors.toList()));
                    try {
                        SQLHintPopup.this.showPopup(SQLHintPopup.this.popupWithColumns);
                    }
                    catch (BadLocationException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
    }
}

