/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.common.BGXMLEventReaderImpl;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.xml.NodeListElementIterator;

public class XMLUtils {
    protected static final String ELEMENT_NAME_ROW = "row";
    protected static final String ELEMENT_NAME_ITEM = "item";
    protected static final String ELEMENT_NAME_LIST = "list";
    protected static final Pattern slashPattern = Pattern.compile("/");

    public static final XMLInputFactory newXMLInputFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlif;
    }

    public static final BGXMLEventReader newXMLEventReader(Reader reader) throws Exception {
        return XMLUtils.newXMLEventReader(XMLUtils.newXMLInputFactory(), reader);
    }

    public static final BGXMLEventReader newXMLEventReader(InputStream is) throws Exception {
        return XMLUtils.newXMLEventReader(XMLUtils.newXMLInputFactory(), is);
    }

    public static final BGXMLEventReader newXMLEventReader(XMLInputFactory xmlif, Reader reader) throws Exception {
        XMLEventReader xmlr = xmlif.createXMLEventReader(reader);
        return new BGXMLEventReaderImpl(xmlif, xmlr);
    }

    public static final BGXMLEventReader newXMLEventReader(XMLInputFactory xmlif, InputStream is) throws Exception {
        XMLEventReader xmlr = xmlif.createXMLEventReader(is);
        return new BGXMLEventReaderImpl(xmlif, xmlr);
    }

    public static final Document newDocument() {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (Exception ex) {
            throw new BGRuntimeException(ex);
        }
    }

    public static final Element createElement(Document parent, String name) {
        Element result = parent.createElement(name);
        parent.appendChild(result);
        return result;
    }

    public static Element createElement(Element parentElement, String name) {
        Element element = null;
        if (parentElement != null && name != null) {
            element = parentElement.getOwnerDocument().createElement(name);
            parentElement.appendChild(element);
        }
        return element;
    }

    public static final Element createElementNS(Document parent, String xmlns, String name) {
        Element result = parent.createElementNS(xmlns, name);
        parent.appendChild(result);
        return result;
    }

    public static void createTextNode(Node node, String text) {
        if (node != null && text != null) {
            node.appendChild(node.getOwnerDocument().createTextNode(text));
        }
    }

    public static Element createListElement(Element parentElement, String name, List<?> list, Class<?> clazz) throws Exception {
        return XMLUtils.createListElement(parentElement, name, list, clazz, null);
    }

    public static Element createListElement(Element parentElement, String name, List<?> list, Class<?> clazz, String[] fields) throws Exception {
        return XMLUtils.createListElement(parentElement, name, ELEMENT_NAME_ITEM, list, clazz, fields);
    }

    public static Element createListElement(Element parentElement, String name, String itemName, List<?> list, Class<?> clazz, String[] fields) throws Exception {
        Element listElement;
        block11: {
            listElement = null;
            if (parentElement == null || name == null) break block11;
            listElement = XMLUtils.createElement(parentElement, name);
            if (list != null) {
                if (clazz.isArray()) {
                    for (Object object : list) {
                        Element itemElement = XMLUtils.createElement(listElement, itemName);
                        if (!(object instanceof String[])) continue;
                        String[] strings = (String[])object;
                        for (int index = 0; index < fields.length; ++index) {
                            if (index >= strings.length) continue;
                            itemElement.setAttribute(fields[index], strings[index]);
                        }
                    }
                } else {
                    Method[] methods = clazz.getMethods();
                    if (fields != null && fields.length > 0) {
                        ArrayList<Method> methodList = new ArrayList<Method>();
                        for (String field : fields) {
                            String methodName = "get".concat(field.substring(0, 1).toUpperCase()).concat(field.substring(1));
                            Method method = clazz.getMethod(methodName, new Class[0]);
                            if (method == null) continue;
                            methodList.add(method);
                        }
                        methods = methodList.toArray(new Method[0]);
                    }
                    for (Object object : list) {
                        Element itemElement = XMLUtils.createElement(listElement, itemName);
                        for (Method method : methods) {
                            String attrName = method.getName();
                            attrName = attrName.substring(3);
                            attrName = attrName.substring(0, 1).toLowerCase().concat(attrName.substring(1));
                            try {
                                Object attrValue = method.invoke(object, (Object[])null);
                                itemElement.setAttribute(attrName, attrValue == null ? "" : attrValue.toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return listElement;
    }

    public static Element addListItem(Node node, int id, String title) {
        return XMLUtils.addListItem(node, ELEMENT_NAME_ITEM, String.valueOf(id), title);
    }

    public static Element addListItem(Node node, String id, String title) {
        return XMLUtils.addListItem(node, ELEMENT_NAME_ITEM, id, title);
    }

    public static Element addListItem(Node node, String nameNode, String id, String title) {
        Element element = XMLUtils.createElement((Element)node, nameNode);
        element.setAttribute("id", id);
        element.setAttribute("title", title);
        return element;
    }

    public static void setPageAttribute(Element element, Page page) {
        if (element != null && page != null) {
            element.setAttribute("recordCount", String.valueOf(page.getRecordCount()));
            element.setAttribute("pageCount", String.valueOf(page.getPageCount()));
            element.setAttribute("pageSize", String.valueOf(page.getPageSize()));
            element.setAttribute("pageIndex", String.valueOf(page.getPageIndex()));
        }
    }

    public static void setAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttribute(name, value);
        }
    }

    public static Document parseDocument(String data) {
        return XMLUtils.parseDocument(new InputSource(new StringReader(data)));
    }

    public static Document parseDocument(byte[] data) {
        return XMLUtils.parseDocument(new InputSource(new ByteArrayInputStream(data)));
    }

    public static Document parseDocument(byte[] data, ErrorShowType errorShowType) {
        return XMLUtils.parseDocument(new InputSource(new ByteArrayInputStream(data)), errorShowType);
    }

    public static Document parseDocument(InputSource source) {
        return XMLUtils.parseDocument(source, ErrorShowType.LOG);
    }

    public static Document parseDocument(InputSource source, ErrorShowType errorShowType) {
        Document result = null;
        if (source != null) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                dFactory.setValidating(false);
                DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                result = docBuilder.parse(source);
            }
            catch (Exception ex) {
                switch (errorShowType) {
                    case LOG: 
                    case EXCEPTION: {
                        throw new BGRuntimeException("error parse xml-document", ex);
                    }
                }
            }
        }
        return result;
    }

    public static void parseDocument(InputSource source, ContentHandler handler) throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        parser.setContentHandler(handler);
        parser.parse(source);
    }

    public static Element getElement(Document doc, String elementName) {
        return (Element)XMLUtils.getNode(doc, elementName);
    }

    public static Node getNode(Document doc, String nodeName) {
        Node node = null;
        if (doc == null) {
            return node;
        }
        NodeList list = doc.getElementsByTagName(nodeName);
        if (list != null && list.getLength() > 0) {
            node = list.item(0);
        } else {
            node = doc.createElement(nodeName);
            doc.getDocumentElement().appendChild(node);
        }
        return node;
    }

    public static Element selectElement(Node node, String expression) throws Exception {
        return (Element)XMLUtils.selectNode(node, expression);
    }

    public static Node selectNode(Node node, String expression) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(expression);
        return (Node)xPathExpression.evaluate(node, XPathConstants.NODE);
    }

    public static Iterable<Element> selectElements(Node node, String expression) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            XPathExpression xPathExpression = xPath.compile(expression);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
            return XMLUtils.elements(nodeList);
        }
        catch (Exception ex) {
            throw new BGRuntimeException();
        }
    }

    public static Iterable<Element> elements(final NodeList nodeList) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new NodeListElementIterator(nodeList);
            }
        };
    }

    public static String selectText(Node node, String expression) throws Exception {
        return XMLUtils.selectText(node, expression, null);
    }

    public static String selectText(Node node, String expression, String defaultValue) throws Exception {
        Node result = XMLUtils.selectNode(node, expression);
        return result != null ? result.getTextContent() : defaultValue;
    }

    public static String getAttribute(Element element, String name) {
        return XMLUtils.getAttribute(element, name, null);
    }

    public static String getAttribute(Element element, String name, String defaultValue) {
        return element != null && element.hasAttribute(name) ? element.getAttribute(name) : defaultValue;
    }

    public static int getAttributeIntValue(Element element, String name, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(XMLUtils.getAttribute(element, name, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private static Map<String, String> attributesToMap0(Element element, boolean needEmpty) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        HashMap<String, String> result = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            Node attribute = attributes.item(i);
            String value = attribute.getNodeValue();
            String name = attribute.getNodeName();
            if (needEmpty) {
                result.put(name, value);
                continue;
            }
            if (value == null || value.length() <= 0) continue;
            result.put(name, value);
        }
        return result;
    }

    public static ParameterMap attributesToParameterMap(Element element, boolean needEmpty) {
        return new ElementParameterMap(element, needEmpty);
    }

    public static ParameterMap attributesToParameterMap(Element element) {
        return XMLUtils.attributesToParameterMap(element, false);
    }

    public static void serialize(Node node, OutputStream os, String encoding) {
        XMLUtils.serialize(node, new StreamResult(os), encoding, false);
    }

    public static void serialize(Node node, Result result, String encoding, boolean indent) {
        XMLUtils.serialize(node, result, XMLUtils.getSerializeProperties(encoding, indent));
    }

    public static String serializeToString(Node node, boolean indent) throws Exception {
        StringWriter writer = new StringWriter();
        XMLUtils.serialize(node, new StreamResult(writer), XMLUtils.getSerializeProperties("UTF-8", indent));
        return writer.toString();
    }

    public static Properties getSerializeProperties(String encoding, boolean indent) {
        return XMLUtils.getSerializeProperties(encoding, indent, false);
    }

    public static Properties getSerializeProperties(String encoding, boolean indent, boolean omitXmlDeclaration) {
        Properties properties = new Properties();
        properties.put("method", "xml");
        if (indent) {
            properties.put("indent", "yes");
            properties.put("{http://xml.apache.org/xslt}indent-amount", "4");
            properties.put("{http://xml.apache.org/xalan}indent-amount", "4");
        }
        if (encoding != null) {
            properties.put("encoding", encoding);
        }
        if (omitXmlDeclaration) {
            properties.put("omit-xml-declaration", "yes");
        }
        return properties;
    }

    public static void serialize(Node node, Result result, Properties properties) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperties(properties);
            transformer.transform(new DOMSource(node), result);
        }
        catch (FactoryConfigurationError | TransformerFactoryConfigurationError e) {
            throw new BGRuntimeException("xml serialize: error transformer factory: " + e.toString(), e);
        }
        catch (TransformerException e) {
            throw new BGRuntimeException("xml serialize: transformer error: " + e.toString(), e);
        }
        catch (Exception e) {
            throw new BGRuntimeException("xml serialize: fatal error: " + e.toString(), e);
        }
    }

    public static void prepareElementToSerialize(Node el) {
        StringBuilder buf = new StringBuilder(100);
        int size = 0;
        NamedNodeMap map = el.getAttributes();
        if (map != null) {
            size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = map.item(i);
                String nodeValue = node.getNodeValue();
                node.setNodeValue(XMLUtils.prepareString(buf, nodeValue));
            }
        }
        if (el.getNodeValue() != null) {
            el.setNodeValue(XMLUtils.prepareString(buf, el.getNodeValue()));
        }
        NodeList childs = el.getChildNodes();
        size = childs.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = childs.item(i);
            XMLUtils.prepareElementToSerialize(child);
        }
    }

    public static String prepareString(StringBuilder buf, String nodeValue) {
        buf.setLength(0);
        for (int j = 0; j < nodeValue.length(); ++j) {
            char ch = nodeValue.charAt(j);
            char ich = ch;
            if (ich == '\t' || ich == '\n' || ich == '\r' || ich >= ' ' && ich <= '\ud7ff' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                buf.append(ch);
                continue;
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        return buf.toString();
    }

    public static void transform(Source xml, Source xslt, Result res, String enc) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslt);
        transformer.transform(xml, res);
        if (enc != null) {
            transformer.setOutputProperty("encoding", enc);
        }
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    public static String escapeXmlNotValid(StringBuilder buf, String value) {
        boolean was = false;
        if (buf == null) {
            buf = new StringBuilder(value.length() + 10);
        } else {
            buf.setLength(0);
        }
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            char ich = ch;
            if (ich >= ' ' && ich <= '\ud7ff' || ich == '\t' || ich == '\n' || ich == '\r' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                if (!was) continue;
                buf.append(ch);
                continue;
            }
            if (!was) {
                was = true;
                buf.append(value, 0, j);
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        if (!was) {
            return value;
        }
        return buf.toString();
    }

    public static void stringToLines(Element node, String str) {
        if (Utils.isEmptyString(str)) {
            return;
        }
        String[] lines = str.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            Element row = XMLUtils.createElement(node, ELEMENT_NAME_ROW);
            row.setAttribute("text", lines[i]);
        }
    }

    public static interface BGXMLEventReader
    extends XMLEventReader {
        public int getCurrentDepth();

        @Deprecated
        public Iterable<StartElement> newStartElementIterator(String var1);

        public Iterable<StartElement> iterable(String var1);

        public String getAttributeValue(StartElement var1, String var2);

        public Map<String, String> getAttributes(StartElement var1);
    }

    public static enum ErrorShowType {
        LOG,
        EXCEPTION,
        SILENT;

    }

    private static class ElementParameterMap
    extends ParameterMap {
        private Element element;
        private boolean needEmpty;
        private Map<String, String> data = null;

        public ElementParameterMap(Element element, boolean needEmpty) {
            assert (element != null);
            this.element = element;
            this.needEmpty = needEmpty;
        }

        @Override
        public String get(String key, String def) {
            if (this.data != null) {
                String result = this.data.get(key);
                return result != null ? result : def;
            }
            assert (this.element != null);
            String value = this.element.getAttribute(key);
            if (value == null || value.length() == 0) {
                return def;
            }
            return value;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this.data != null) {
                return this.data.entrySet();
            }
            this.data = XMLUtils.attributesToMap0(this.element, this.needEmpty);
            this.element = null;
            return this.data.entrySet();
        }
    }

    public static class XMLEventReaderParameterMap
    extends ParameterMap.DefaultParameterMap {
        public XMLEventReaderParameterMap() {
            super(new HashMap<String, String>());
        }

        public void read(StartElement element) {
            this.data.clear();
            Iterator<Attribute> i = element.getAttributes();
            while (i.hasNext()) {
                Attribute attr = i.next();
                this.data.put(attr.getName().getLocalPart(), attr.getValue());
            }
        }
    }

    public static class XMLStreamReaderParameterMap
    extends ParameterMap.DefaultParameterMap {
        public XMLStreamReaderParameterMap() {
            super(new HashMap<String, String>());
        }

        public void read(XMLStreamReader reader) {
            this.data.clear();
            int size = reader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                this.data.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
        }
    }
}

