/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.logging.BGNestedContext;

public class SetCharacterEncodingFilter
extends BGLogger
implements Filter {
    protected String encoding;
    protected FilterConfig filterConfig;
    protected boolean ignore;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.ignore || request.getCharacterEncoding() == null) {
            String header = ((HttpServletRequest)request).getHeader("X-Requested-With");
            if (header != null && "XMLHttpRequest".equals(header)) {
                request.setCharacterEncoding("UTF-8");
            } else {
                String encoding = this.selectEncoding(request);
                if (encoding != null) {
                    request.setCharacterEncoding(encoding);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        String value = filterConfig.getInitParameter("ignore");
        boolean bl = this.ignore = value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        if (this.getLogger().isDebugEnabled()) {
            BGNestedContext.push((String)"filter");
            this.getLogger().debug("init filter " + filterConfig.getFilterName() + " (encoding=" + this.encoding + ", ignore=" + this.ignore + ")");
            BGNestedContext.pop();
        }
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }
}

