/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.kernel;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.Consumer;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.cache.FileBasedLocalCache;
import org.jxmapviewer.cache.LocalCache;
import org.jxmapviewer.input.CenterMapListener;
import org.jxmapviewer.input.PanKeyListener;
import org.jxmapviewer.input.PanMouseInputListener;
import org.jxmapviewer.input.ZoomMouseWheelListenerCursor;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import ru.bitel.bgbilling.kernel.map.kernel.MapViewerHelper;
import ru.bitel.bgbilling.kernel.map.kernel.SelectionAdapter;
import ru.bitel.common.Utils;

public class DefaultMapViewer
extends JXMapViewer {
    private static final int THREAD_POOL_SIZE = 12;
    private TileFactoryInfo tileFactoryInfo = new OSMTileFactoryInfo();
    private DefaultTileFactory tileFactory = new DefaultTileFactory(this.tileFactoryInfo);
    private SelectionAdapter selectionAdapter;
    private boolean popupMenuStatus = true;
    private MapViewerHelper helper;

    public DefaultMapViewer() {
        this.tileFactory.setThreadPoolSize(12);
        this.setCacheDir(this.getDefaultCacheDirPath());
        this.setTileFactory((TileFactory)this.tileFactory);
        this.setSelectionAdapter(new SelectionAdapter(this));
        this.initMouseListeners();
    }

    public void setCacheDir(String cacheDirPath) {
        File cacheDir = new File(Utils.isBlankString((String)cacheDirPath) ? this.getDefaultCacheDirPath() : cacheDirPath);
        if (Files.exists(cacheDir.toPath(), new LinkOption[0])) {
            this.tileFactory.setLocalCache((LocalCache)new FileBasedLocalCache(cacheDir, false));
        }
    }

    public String getDefaultCacheDirPath() {
        return System.getProperty("user.home") + File.separator + ".bgmapviewer";
    }

    protected void initMouseListeners() {
        PanMouseInputListener mouseInputListener = new PanMouseInputListener((JXMapViewer)this);
        this.addMouseListener((MouseListener)mouseInputListener);
        this.addMouseMotionListener((MouseMotionListener)mouseInputListener);
        this.addMouseListener((MouseListener)new CenterMapListener((JXMapViewer)this));
        this.addMouseWheelListener((MouseWheelListener)new ZoomMouseWheelListenerCursor((JXMapViewer)this));
        this.addKeyListener((KeyListener)new PanKeyListener((JXMapViewer)this));
    }

    public SelectionAdapter getSelectionAdapter() {
        return this.selectionAdapter;
    }

    public void setSelectionAdapter(SelectionAdapter selectionAdapter) {
        this.selectionAdapter = selectionAdapter;
        this.addMouseListener(selectionAdapter);
        this.addMouseMotionListener(selectionAdapter);
    }

    public void setMouseClickListener(Consumer<MouseEvent> clickListener) {
        this.selectionAdapter.addMouseClickListener(clickListener);
    }

    public DefaultTileFactory getTileFactory() {
        return this.tileFactory;
    }

    public void setTileFactory(TileFactory tileFactory) {
        if (tileFactory == null) {
            throw new NullPointerException("TileFactory is null!");
        }
        this.tileFactoryInfo = tileFactory.getInfo();
        this.tileFactory = (DefaultTileFactory)tileFactory;
        this.tileFactory.setThreadPoolSize(12);
        super.setTileFactory(tileFactory);
    }

    public void setPopupMenuStatus(boolean enable) {
        this.popupMenuStatus = enable;
    }

    public boolean popupMenuIsEnable() {
        return this.popupMenuStatus;
    }

    public void setHelper(MapViewerHelper helper) {
        this.helper = helper;
    }

    public MapViewerHelper getHelper() {
        return this.helper;
    }
}

