/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Shutdown {
    private static AtomicInteger shutdownHooks = new AtomicInteger(0);
    private static List<OnShutdown> onShutdownList = new ArrayList<OnShutdown>(3);

    public static void addShutdownHook(final Runnable hook) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                hook.run();
                Shutdown.shutdownHookStopped();
            }
        };
        shutdownHooks.incrementAndGet();
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private static void shutdownHookStopped() {
        if (shutdownHooks.decrementAndGet() <= 0) {
            for (OnShutdown onShutdown : onShutdownList) {
                onShutdown.onShutdown();
            }
        }
    }

    public static synchronized void addOnShutdown(OnShutdown onShutdown) {
        onShutdownList.add(onShutdown);
    }

    static {
        Shutdown.addShutdownHook(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public static interface OnShutdown {
        public void onShutdown();
    }
}

