/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.access.om;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.manage.DeviceManageWorker;
import ru.bitel.bgbilling.apps.tv.access.om.OrderManagerDeviceWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.server.event.TvReloadEvent;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public class AccessDeviceManager
extends Thread
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final TvAccess access;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentMap<Integer, OrderManagerDeviceWorker> omDeviceWorkerMap;
    private final ConcurrentMap<Integer, DeviceManageWorker> deviceManageWorkerMap;

    public AccessDeviceManager(final TvAccess access) throws BGException {
        this.access = access;
        this.omDeviceWorkerMap = new ConcurrentHashMap<Integer, OrderManagerDeviceWorker>(access.childrenDeviceIds.size());
        this.deviceManageWorkerMap = new ConcurrentHashMap<Integer, DeviceManageWorker>(access.childrenDeviceIds.size());
        this.scheduledExecutorService = WorkerTask.newScheduledThreadPool((String)"sa", (String)"connection", (ThreadContextFactory)new ThreadContextFactory<EventListenerContext>(){

            public EventListenerContext newThreadContext() {
                return new EventListenerContext(access.setup, access.moduleId, SetupParam.getApplicationName());
            }
        }, (int)100);
        for (Integer deviceId : access.childrenDeviceIds) {
            this.omDeviceWorkerMap.put(deviceId, new OrderManagerDeviceWorker(access, this.scheduledExecutorService, deviceId));
            TvDeviceRuntime deviceRuntime = access.deviceMap.get(deviceId);
            if (deviceRuntime == null || deviceRuntime.deviceManager == null) continue;
            DeviceManageWorker w = new DeviceManageWorker(access, this, this.scheduledExecutorService, deviceId, deviceId);
            this.deviceManageWorkerMap.put(deviceId, w);
            w.start();
        }
        Shutdown.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                for (OrderManagerDeviceWorker worker : AccessDeviceManager.this.omDeviceWorkerMap.values()) {
                    try {
                        worker.shutdown();
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    AccessDeviceManager.this.scheduledExecutorService.shutdown();
                    AccessDeviceManager.this.scheduledExecutorService.awaitTermination(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        EventProcessor.getInstance().addListener((EventListener)this, TvReloadEvent.class, access.moduleId, null);
    }

    public synchronized void notify(Event e, EventListenerContext ctx) throws BGException {
        for (Integer deviceId : this.access.childrenDeviceIds) {
            TvDeviceRuntime deviceRuntime;
            if (this.omDeviceWorkerMap.get(deviceId) == null) {
                this.omDeviceWorkerMap.put(deviceId, new OrderManagerDeviceWorker(this.access, this.scheduledExecutorService, deviceId));
            }
            if ((deviceRuntime = this.access.deviceMap.get(deviceId)) == null || this.deviceManageWorkerMap.containsKey(deviceRuntime.tvDevice.getId())) continue;
            this.deviceManageWorkerMap.put(deviceRuntime.tvDevice.getId(), new DeviceManageWorker(this.access, this, this.scheduledExecutorService, deviceRuntime.tvDevice.getId(), deviceId));
        }
    }
}

