/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.calc;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSessionUtils;
import ru.bitel.bgbilling.modules.dialup.server.calc.CalcPeriod;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ContractData {
    public int cid;
    public TariffTreeSet tts;
    public ContractTariffOptionList tariffOptions;
    public List<CalcPeriod> calcPeriods;
    public Map<Integer, List<DialUpSessionUtils.ServiceRange>> serviceRanges;
    public List<Period> suspendedPeriods;
    private CalcPeriod defaultPeriod;

    public ContractData(int cid, CalcPeriod defaultPeriod) {
        this.cid = cid;
        this.defaultPeriod = defaultPeriod;
    }

    public CalcPeriod getCalcPeriod(Calendar date) {
        CalcPeriod result = null;
        for (CalcPeriod period : this.calcPeriods) {
            if (!TimeUtils.dateBeforeOrEq((Calendar)period.start, (Calendar)date) || !TimeUtils.dateBeforeOrEq((Calendar)date, (Calendar)period.end)) continue;
            result = period;
            break;
        }
        if (result == null) {
            result = this.defaultPeriod;
        }
        return result;
    }
}

