/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.tariff;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class TariffZoneTariffTreeNode
extends DefaultTariffTreeNode {
    public static final int ACTION_NOTHING = 0;
    public static final int ACTION_DISCONNECT = 1;
    public static final int ACTION_CoA = 2;
    private String zoneSet = "";
    private String zone;
    private int action;
    private boolean addPayment;
    private int paymentType;
    private float paymentSum;
    private String eventName;

    public void init(String data, int deep, int nodeId) {
        String[] params;
        super.init(data, deep, nodeId);
        Map dataHash = this.getDataInHash();
        this.zone = (String)dataHash.get("zone");
        if (this.zone == null) {
            this.zone = "";
        }
        if ((params = this.zone.split(":", 2)).length == 2) {
            this.zoneSet = params[0];
        }
        this.action = Utils.parseInt((String)((String)dataHash.get("disconnect")));
        this.addPayment = "1".equals(dataHash.get("addPayment"));
        this.paymentType = Utils.parseInt((String)((String)dataHash.get("paymentType")), (int)0);
        this.paymentSum = Utils.parseFloat((String)((String)dataHash.get("paymentSum")), (float)0.0f);
        this.eventName = (String)dataHash.get("eventName");
        if (this.paymentSum <= 0.0f) {
            this.addPayment = false;
        }
    }

    public void processRequest(TariffRequest request) {
        HashMap<String, TariffZoneTariffTreeNode> map = (HashMap<String, TariffZoneTariffTreeNode>)request.getResponseParam("dialupTariffZoneMap");
        if (map == null) {
            map = new HashMap<String, TariffZoneTariffTreeNode>(4);
            request.setResponseParam("dialupTariffZoneMap", map);
        }
        map.put(this.zoneSet, this);
    }

    public boolean isAddPayment() {
        return this.addPayment;
    }

    public boolean needDisconnect() {
        return this.action == 1;
    }

    public boolean needCoA() {
        return this.action == 2;
    }

    public float getPaymentSum() {
        return this.paymentSum;
    }

    public int getPaymentType() {
        return this.paymentType;
    }

    public String getZone() {
        return this.zone;
    }

    public String getZoneSet() {
        return this.zoneSet;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String toString() {
        return this.zone;
    }
}

