/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.pattern;

import bitel.billing.module.common.BGFileFilter;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.ws.Holder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.documents.client.pattern.ClassChooser;
import ru.bitel.bgbilling.plugins.documents.client.pattern.TableEditorDialog;
import ru.bitel.bgbilling.plugins.documents.client.pattern.VariableEditorDialog;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariableType;
import ru.bitel.bgbilling.plugins.documents.common.bean.SupportedFileFormat;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.client.tree.BGCheckTreeModel;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;

public class DocumentsPatternPanel
extends BGUPanel {
    private BGUTable patternTable;
    private DocumentPatternTableModel patternTableModel;
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.OK, BGButtonPanel.CANCEL});
    private BGTextField patternName = new BGTextField();
    private BGTextField patternComment = new BGTextField();
    private BGTextField generatedFileName = new BGTextField();
    private BGTextField fileComment = new BGTextField();
    private BGTextField patternFileName = new BGTextField();
    private BGTextField documentName = new BGTextField();
    private BGTextField documentComment = new BGTextField();
    private JCheckBox visibleInPlugin = new JCheckBox("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0432 \u043f\u043b\u0430\u0433\u0438\u043d\u0435", true);
    private JButton chooseFileButton = new JButton("...");
    private JButton downloadFileButton = new JButton(ClientUtils.getIcon((String)"item_down.png"));
    private JButton deleteFileButton = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private JButton openFileButton = new JButton(ClientUtils.getIcon((String)"open.png"));
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel domainPanel = new JPanel(new BorderLayout());
    private BGUCheckTree<Domain> domains = new BGUCheckTree((BGCheckTreeModel)new BGCheckTreeModel<Domain>("domains", Domain.class){
        private Icon folder;
        private Icon leaf;
        {
            this.folder = ClientUtils.getIcon((String)"fugue/tree");
            this.leaf = ClientUtils.getIcon((String)"fugue/leaf");
        }

        public Icon getIcon(Domain value) {
            return this.isLeaf(value) ? this.leaf : this.folder;
        }
    });
    private ClassChooser classChooserPanel;
    private JPanel variablesPanel = new JPanel(new GridBagLayout());
    private BGUTable variablesTable;
    private VariablesTableModel variablesTableModel;
    private JButton addVariableButton = new JButton(ClientUtils.getIcon((String)"add.png"));
    private JButton editVariableButton = new JButton(ClientUtils.getIcon((String)"edit.png"));
    private JButton deleteVariableButton = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private JPanel tablesPanel = new JPanel(new GridBagLayout());
    private BGUTable tablesTable;
    private DocumentTableModel tablesTableModel;
    private JButton addTableButton = new JButton(ClientUtils.getIcon((String)"add.png"));
    private JButton editTableButton = new JButton(ClientUtils.getIcon((String)"edit.png"));
    private JButton deleteTableButton = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private DocumentPattern currentPattern = null;
    private File selectedFile;
    private DocumentsPatternService patternService;

    protected void jbInit() throws Exception {
        this.classChooserPanel = new ClassChooser((ClientContext)this.getContext());
        this.patternTableModel = new DocumentPatternTableModel(DocumentPatternTableModel.class.getName());
        this.patternTable = new BGUTable((TableModel)((Object)this.patternTableModel));
        this.patternTable.setSelectionMode(0);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0421\u0434\u0435\u043b\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u044e \u0448\u0430\u0431\u043b\u043e\u043d\u0430").addActionListener(e -> this.performAction("docPattern.clone"));
        this.variablesTableModel = new VariablesTableModel("variables");
        this.variablesTable = new BGUTable((TableModel)((Object)this.variablesTableModel));
        this.variablesTable.setSelectionMode(0);
        this.tablesTableModel = new DocumentTableModel();
        this.tablesTable = new BGUTable((TableModel)((Object)this.tablesTableModel));
        this.tablesTable.setSelectionMode(0);
        this.patternFileName.setEnabled(false);
        this.patternFileName.getDocument().addDocumentListener(new FileNameDocumentListener());
        this.tabbedPane.addTab("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435", this.variablesPanel);
        this.tabbedPane.addTab("\u0422\u0430\u0431\u043b\u0438\u0446\u044b", this.tablesPanel);
        this.tabbedPane.addTab("\u0414\u043e\u043c\u0435\u043d\u044b", this.domainPanel);
        this.chooseFileButton.setToolTipText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        this.openFileButton.setToolTipText("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 \u043d\u0430 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0435");
        this.downloadFileButton.setToolTipText("\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440");
        this.deleteFileButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
        this.addVariableButton.setBorder(null);
        this.addVariableButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        this.editVariableButton.setBorder(null);
        this.editVariableButton.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        this.deleteVariableButton.setBorder(null);
        this.deleteVariableButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        JPanel varButtonPanel = new JPanel(new GridLayout(1, 3, 10, 0));
        varButtonPanel.add(this.addVariableButton);
        varButtonPanel.add(this.editVariableButton);
        varButtonPanel.add(this.deleteVariableButton);
        this.variablesPanel.add((Component)varButtonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.variablesPanel.add((Component)new JScrollPane((Component)this.variablesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addTableButton.setBorder(null);
        this.addTableButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
        this.editTableButton.setBorder(null);
        this.editTableButton.setToolTipText("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
        this.deleteTableButton.setBorder(null);
        this.deleteTableButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
        JPanel tableButtonPanel = new JPanel(new GridLayout(1, 3, 10, 0));
        tableButtonPanel.add(this.addTableButton);
        tableButtonPanel.add(this.editTableButton);
        tableButtonPanel.add(this.deleteTableButton);
        this.tablesPanel.add((Component)tableButtonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tablesPanel.add((Component)new JScrollPane((Component)this.tablesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.domainPanel.add(new JScrollPane((Component)this.domains));
        JPanel paramsPanel = new JPanel(new GridBagLayout());
        paramsPanel.add((Component)new JLabel("\u0418\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.patternName, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043a \u0448\u0430\u0431\u043b\u043e\u043d\u0443"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.patternComment, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u0424\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.patternFileName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.chooseFileButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.openFileButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.downloadFileButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.deleteFileButton, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u0418\u043c\u044f \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.documentName, new GridBagConstraints(1, 3, 5, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.documentComment, new GridBagConstraints(1, 4, 5, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u0418\u043c\u044f \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.generatedFileName, new GridBagConstraints(1, 5, 5, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)this.fileComment, new GridBagConstraints(1, 6, 5, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)new JLabel("\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043b\u0430\u0441\u0441"), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)((Object)this.classChooserPanel), new GridBagConstraints(1, 7, 5, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.classChooserPanel.setToolTipText("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043a\u043b\u0430\u0441\u0441 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043c\u043e\u0436\u043d\u043e \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445, \u0442\u0430\u0431\u043b\u0438\u0446 \u0441 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u043c\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u043c\u0438. \u0412 \u0441\u043b\u0443\u0447\u0430\u0435, \u0435\u0441\u043b\u0438 \u043a\u0430\u043a\u0430\u044f \u0442\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0431\u0443\u0434\u0435\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0438 \u0432 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u043a\u043e\u0434\u0435 \u0438 \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445, \u0442\u043e \u0432\u044b\u0448\u0435 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u0443 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0432 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u043a\u043e\u0434\u0435");
        paramsPanel.add((Component)this.visibleInPlugin, new GridBagConstraints(0, 8, 5, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.visibleInPlugin.setToolTipText("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043b\u0438 \u0448\u0430\u0431\u043b\u043e\u043d \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435, \u0447\u0442\u043e \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u043c \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043d\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0435.");
        this.editor.add((Component)paramsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.patternTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(1, 0, 1, 1, 0.3, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JLabel("\u0414\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432, \u043f\u0435\u0440\u0435\u0442\u0430\u0449\u0438\u0442\u0435 \u043c\u044b\u0448\u043a\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438."), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.patternTable.setDragEnabled(true);
        this.patternTable.setDropMode(DropMode.INSERT_ROWS);
        this.patternTable.setTransferHandler((TransferHandler)new TableRowTransferHandler(this.patternTableModel));
        this.chooseFileButton.addActionListener(actionEvent -> {
            BGFileChooser chooser = new BGFileChooser((Component)this.chooseFileButton);
            chooser.setFileFilter((FileFilter)new BGFileFilter("odt|docx|xlsx", "\u0424\u0430\u0439\u043b\u044b MS Office/Open Document"));
            if (chooser.showOpenDialog((Component)this.chooseFileButton) == 0) {
                this.selectedFile = chooser.getSelectedFile();
                SupportedFileFormat fileExtension = SupportedFileFormat.getSupportedFormat((String)FilenameUtils.getExtension((String)this.selectedFile.getName()));
                if (!(fileExtension.equals((Object)SupportedFileFormat.ODT) || fileExtension.equals((Object)SupportedFileFormat.DOCX) || fileExtension.equals((Object)SupportedFileFormat.XLSX))) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430!");
                    return;
                }
                this.patternFileName.setText(this.selectedFile.getName());
            }
        });
        this.openFileButton.addActionListener(actionEvent -> this.performAction("openFile"));
        this.downloadFileButton.addActionListener(actionEvent -> this.performAction("downloadFile"));
        this.deleteFileButton.addActionListener(actionEvent -> this.performAction("deleteFile"));
        this.buttonPanel.addActionListener(actionEvent -> {
            String command = actionEvent.getActionCommand();
            if (command.equals("ok")) {
                this.performAction("ok");
            } else {
                this.editor.setVisible(false);
                this.patternTable.setEnabled(true);
            }
        });
        BGSwingUtilites.handleMouseClicked((Component)this.patternTable, e -> this.patternTableMouseClicked(popupMenu, (MouseEvent)e));
        BGSwingUtilites.handleLDMouseClicked((Component)this.variablesPanel, e -> this.performAction("editVariable"));
        BGSwingUtilites.handleLDMouseClicked((Component)this.tablesTable, e -> this.performAction("editTable"));
        this.addVariableButton.addActionListener(e -> this.performAction("addVariable"));
        this.editVariableButton.addActionListener(e -> this.performAction("editVariable"));
        this.deleteVariableButton.addActionListener(e -> this.performAction("deleteVariable"));
        this.addTableButton.addActionListener(e -> this.performAction("addTable"));
        this.editTableButton.addActionListener(e -> this.performAction("editTable"));
        this.deleteTableButton.addActionListener(e -> this.performAction("deleteTable"));
    }

    private void patternTableMouseClicked(JPopupMenu popupMenu, MouseEvent event) {
        DocumentPattern selectedPattern;
        if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
            this.performAction("edit");
        } else if (SwingUtilities.isRightMouseButton(event) && (selectedPattern = (DocumentPattern)this.patternTableModel.getSelectedRow()) != null) {
            popupMenu.show((Component)this.patternTable, event.getX(), event.getY());
        }
    }

    private DocumentsPatternService getDocumentsPatternService() {
        if (this.patternService == null) {
            this.patternService = (DocumentsPatternService)((ClientContext)this.getContext()).getPort(DocumentsPatternService.class);
        }
        return this.patternService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.classChooserPanel.dynClassChooser.setIfaceName(this.getDocumentsPatternService().getPatternExtractorIfaceClassName());
            this.classChooserPanel.dynClassChooser.performAction("refresh");
            List list = this.getDocumentsPatternService().getPatternList(-1);
            this.patternTableModel.setData(list, true);
            Domain root = ((DomainService)((ClientContext)this.getContext()).getPort(DomainService.class, 0)).domainTree();
            if (root != null) {
                root.setTitle("\u0414\u043e\u043c\u0435\u043d\u044b");
            }
            this.domains.setData((Id)root);
            this.domains.expand();
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.performActionOpen();
            this.currentPattern = null;
            this.patternName.setText("");
            this.documentName.setText("");
            this.documentComment.setText("");
            this.generatedFileName.setText("");
            this.visibleInPlugin.setSelected(true);
            this.variablesTableModel.setData(null);
            this.tablesTableModel.setData(null);
            this.patternComment.setText("");
            this.domains.clearSelection();
            this.patternFileName.setText("");
            this.fileComment.setText("");
            this.selectedFile = null;
            this.classChooserPanel.dynClassChooser.setSelectedIndex(0);
            this.editor.setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.performActionOpen();
            DocumentPattern selectedPattern = (DocumentPattern)this.patternTableModel.getSelectedRow();
            if (selectedPattern != null) {
                selectedPattern = this.getDocumentsPatternService().getPattern(selectedPattern.getId());
                this.patternTable.setEnabled(false);
                this.currentPattern = selectedPattern;
                this.patternName.setText(selectedPattern.getTitle());
                this.documentName.setText(selectedPattern.getDocumentName());
                this.documentComment.setText(selectedPattern.getDocumentComment());
                this.generatedFileName.setText(selectedPattern.getGeneratedFileNamePattern());
                this.fileComment.setText(selectedPattern.getFileComment());
                this.visibleInPlugin.setSelected(selectedPattern.isVisibleInPlugin());
                this.variablesTableModel.setData(selectedPattern.getVariableList());
                this.tablesTableModel.setData(selectedPattern.getTableList());
                List domainList = selectedPattern.getDomainList();
                if (domainList != null && domainList.size() > 0) {
                    this.domains.setChecked(new HashSet(domainList));
                }
                this.patternComment.setText(selectedPattern.getComment());
                this.classChooserPanel.dynClassChooser.setSelectedItem(Utils.notBlankString((String)selectedPattern.getDataExtractorClass()) ? selectedPattern.getDataExtractorClass() : " --- ");
                Holder fileNameHolder = new Holder();
                this.getDocumentsPatternService().getEmbeddedFilename(this.currentPattern.getId(), fileNameHolder);
                this.patternFileName.setText((String)fileNameHolder.value);
                this.editor.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            DocumentPattern selectedPattern = (DocumentPattern)this.patternTableModel.getSelectedRow();
            if (selectedPattern != null) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.getDocumentsPatternService().deletePattern(selectedPattern.getId());
                    this.performAction("refresh");
                }
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d!");
            }
        });
        new AbstractBGUPanel.DefaultAction("ok", "OK"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                String name = DocumentsPatternPanel.this.patternName.getText();
                if (Utils.isBlankString((String)name)) {
                    BGToolTip.showErrorMessage((JComponent)DocumentsPatternPanel.this.patternName, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0438\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430!");
                    return;
                }
                if (DocumentsPatternPanel.this.currentPattern == null) {
                    DocumentsPatternPanel.this.currentPattern = new DocumentPattern();
                }
                DocumentsPatternPanel.this.currentPattern.setTitle(name);
                DocumentsPatternPanel.this.currentPattern.setDocumentName(DocumentsPatternPanel.this.documentName.getText());
                DocumentsPatternPanel.this.currentPattern.setDocumentComment(DocumentsPatternPanel.this.documentComment.getText());
                DocumentsPatternPanel.this.currentPattern.setGeneratedFileNamePattern(DocumentsPatternPanel.this.generatedFileName.getText());
                DocumentsPatternPanel.this.currentPattern.setFileComment(DocumentsPatternPanel.this.fileComment.getText());
                DocumentsPatternPanel.this.currentPattern.setComment(DocumentsPatternPanel.this.patternComment.getText());
                DocumentsPatternPanel.this.currentPattern.setVisibleInPlugin(DocumentsPatternPanel.this.visibleInPlugin.isSelected());
                DocumentsPatternPanel.this.currentPattern.setVariableList(DocumentsPatternPanel.this.variablesTableModel.getRows());
                DocumentsPatternPanel.this.currentPattern.setTableList(DocumentsPatternPanel.this.tablesTableModel.getRows());
                DocumentsPatternPanel.this.currentPattern.setDataExtractorClass(DocumentsPatternPanel.this.classChooserPanel.dynClassChooser.getSelectedClass());
                ArrayList domainList = new ArrayList(DocumentsPatternPanel.this.domains.getChecked());
                DocumentsPatternPanel.this.currentPattern.setDomainList(domainList);
                DocumentsPatternPanel.this.currentPattern.setId(DocumentsPatternPanel.this.getDocumentsPatternService().updatePattern(DocumentsPatternPanel.this.currentPattern));
                if (DocumentsPatternPanel.this.selectedFile != null) {
                    Holder data = new Holder();
                    data.value = new DataHandler(new DataSource(){

                        public OutputStream getOutputStream() {
                            return null;
                        }

                        public String getName() {
                            return null;
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(DocumentsPatternPanel.this.selectedFile);
                        }

                        public String getContentType() {
                            return "application/octet-stream";
                        }
                    });
                    BGServerFile serverFile = new BGServerFile();
                    serverFile.setTitle(DocumentsPatternPanel.this.patternFileName.getText());
                    serverFile.setOwnerId(DocumentsPatternPanel.this.currentPattern.getId());
                    serverFile.setDate(new Date());
                    DocumentsPatternPanel.this.getDocumentsPatternService().uploadPatternFile(serverFile, data);
                }
                DocumentsPatternPanel.this.editor.setVisible(false);
                DocumentsPatternPanel.this.performAction("refresh");
                DocumentsPatternPanel.this.selectedFile = null;
                DocumentsPatternPanel.this.patternTable.setEnabled(true);
            }
        };
        new AbstractBGUPanel.MenuAction("docPattern.clone", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u044e \u0448\u0430\u0431\u043b\u043e\u043d\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DocumentsPatternPanel.this.getDocumentsPatternService().clonePattern(((DocumentPattern)DocumentsPatternPanel.this.patternTableModel.getSelectedRow()).getId());
                DocumentsPatternPanel.this.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("addVariable", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                DocumentVariable variable = VariableEditorDialog.showVariableEditor(null, DocumentsPatternPanel.this.variablesTableModel.getRows(), true);
                if (variable != null) {
                    DocumentsPatternPanel.this.variablesTableModel.addRow(variable);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("editVariable", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                DocumentVariable selectedVariable = (DocumentVariable)DocumentsPatternPanel.this.variablesTableModel.getSelectedRow();
                if (selectedVariable != null) {
                    selectedVariable = VariableEditorDialog.showVariableEditor(selectedVariable, DocumentsPatternPanel.this.variablesTableModel.getRows(), false);
                    int index = DocumentsPatternPanel.this.variablesTable.getSelectedRow();
                    DocumentsPatternPanel.this.variablesTableModel.setRow(index, selectedVariable);
                } else {
                    BGToolTip.showErrorMessage((JComponent)DocumentsPatternPanel.this.editVariableButton, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteVariable", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                DocumentVariable selectedVariable = (DocumentVariable)DocumentsPatternPanel.this.variablesTableModel.getSelectedRow();
                if (selectedVariable != null) {
                    DocumentsPatternPanel.this.variablesTableModel.deleteRow(selectedVariable);
                } else {
                    BGToolTip.showErrorMessage((JComponent)DocumentsPatternPanel.this.deleteVariableButton, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("addTable", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                DocumentTable table = TableEditorDialog.showTableEditor(null, (ClientContext)DocumentsPatternPanel.this.getContext(), DocumentsPatternPanel.this.currentPattern.getTableList());
                if (table != null) {
                    DocumentsPatternPanel.this.tablesTableModel.addRow(table);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("editTable", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                DocumentTable selectedTable = (DocumentTable)DocumentsPatternPanel.this.tablesTableModel.getSelectedRow();
                if (selectedTable != null) {
                    selectedTable = TableEditorDialog.showTableEditor(selectedTable, (ClientContext)DocumentsPatternPanel.this.getContext(), DocumentsPatternPanel.this.currentPattern.getTableList());
                    int index = DocumentsPatternPanel.this.tablesTable.getSelectedRow();
                    DocumentsPatternPanel.this.tablesTableModel.setRow(index, selectedTable);
                } else {
                    BGToolTip.showErrorMessage((JComponent)DocumentsPatternPanel.this.editTableButton, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteTable", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                DocumentTable selectedTable = (DocumentTable)DocumentsPatternPanel.this.tablesTableModel.getSelectedRow();
                if (selectedTable != null) {
                    DocumentsPatternPanel.this.tablesTableModel.deleteRow(selectedTable);
                } else {
                    BGToolTip.showErrorMessage((JComponent)DocumentsPatternPanel.this.deleteTableButton, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("downloadFile", "\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                BGFileChooser chooser = new BGFileChooser((Component)DocumentsPatternPanel.this.downloadFileButton);
                chooser.setFileFilter((FileFilter)new BGFileFilter("odt|doc|docx", "\u0424\u0430\u0439\u043b\u044b MS Office/Open Document"));
                File dir = chooser.getCurrentDirectory();
                File selfile = new File(dir.getAbsoluteFile() + File.separator + DocumentsPatternPanel.this.patternFileName.getText());
                chooser.setSelectedFile(selfile);
                if (chooser.showSaveDialog() == 0) {
                    File file = chooser.getSelectedFile();
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        Holder fileDataHandler = new Holder();
                        DocumentsPatternPanel.this.getDocumentsPatternService().downloadPatternFile(DocumentsPatternPanel.this.currentPattern.getId(), fileDataHandler);
                        ((DataHandler)fileDataHandler.value).writeTo((OutputStream)fos);
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("openFile", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                File file;
                if (DocumentsPatternPanel.this.selectedFile != null) {
                    ClientUtils.openFile((File)DocumentsPatternPanel.this.selectedFile);
                    return;
                }
                String filePath = DocumentsPatternPanel.this.getDocumentsPatternService().getFilePath(DocumentsPatternPanel.this.currentPattern.getId());
                if (filePath != null && (file = new File(filePath)).exists()) {
                    ClientUtils.openFile((File)file);
                    return;
                }
                Holder fileData = new Holder();
                BGServerFile serverFile = DocumentsPatternPanel.this.getDocumentsPatternService().downloadPatternFile(DocumentsPatternPanel.this.currentPattern.getId(), fileData);
                String serverTitle = serverFile.getTitle();
                String preffix = serverTitle.substring(0, serverTitle.lastIndexOf("."));
                String suffix = serverTitle.substring(serverTitle.lastIndexOf("."));
                File tmpFile = File.createTempFile(preffix, suffix);
                try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                    ((DataHandler)fileData.value).writeTo((OutputStream)fos);
                    ClientUtils.openFile((File)tmpFile);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteFile", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    if (DocumentsPatternPanel.this.currentPattern != null) {
                        DocumentsPatternPanel.this.getDocumentsPatternService().deletePatternFile(DocumentsPatternPanel.this.currentPattern.getId());
                    } else {
                        DocumentsPatternPanel.this.selectedFile = null;
                    }
                    DocumentsPatternPanel.this.fileComment.setText("");
                    DocumentsPatternPanel.this.patternFileName.setText("");
                }
            }
        };
    }

    public void performActionOpen() {
        this.domains.clearChecked();
        this.tabbedPane.setSelectedIndex(0);
        this.domains.expand();
    }

    public void reorder() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        int pos = 1;
        for (DocumentPattern documentPattern : this.patternTableModel.getRows()) {
            documentPattern.setPos(pos++);
            list.add(new int[]{documentPattern.getId(), documentPattern.getPos()});
        }
        this.patternTable.revalidate();
        try {
            this.getDocumentsPatternService().updatePos(list);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class DocumentPatternTableModel
    extends BGTableModel<DocumentPattern> {
        static final String COLUMN_ID = "id";
        static final String COLUMN_USER = "user";
        private Directory<UserInfo> userDirectory;

        DocumentPatternTableModel(String name) {
            super(name, DocumentPattern.class);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u043e\u0440\u0442.", 60, 60, 60, "pos", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430", 100, 400, 800, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0432 \u043f\u043b\u0430\u0433\u0438\u043d\u0435", Boolean.class, -1, 180, 200, "isUseInPlugin", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Column.DateTime.class, -1, 150, 150, "createPatternDate", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", Column.DateTime.class, -1, 230, 250, "lastModifyPatternDate", false);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 100, 200, 300, COLUMN_USER, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(DocumentPattern value, int columnIndex) throws Exception {
            String identifier = this.getIdentifier(columnIndex);
            if (COLUMN_USER.equals(identifier)) {
                UserInfo user = (UserInfo)this.getUserDirectory().get(value.getUserId());
                return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
            }
            return super.getValue((Object)value, columnIndex);
        }

        private Directory<UserInfo> getUserDirectory() throws BGException {
            if (this.userDirectory == null) {
                this.userDirectory = ((ClientContext)DocumentsPatternPanel.this.getContext()).getDirectory(UserInfo.class, 0);
            }
            return this.userDirectory;
        }
    }

    class VariablesTableModel
    extends BGTableModel<DocumentVariable> {
        VariablesTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0418\u043c\u044f", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", -1, -1, -1, "type", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(DocumentVariable val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("type".equals(identifier)) {
                return val.getType().getTitle();
            }
            if ("value".equals(identifier)) {
                Date dt;
                String paramName = val.getValue();
                DocumentVariableType type = val.getType();
                if (type.equals((Object)DocumentVariableType.CONTRACT_PARAM)) {
                    ContractParameterGroupAttr contractParameterGroupAttr;
                    paramName = "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440>";
                    int parameterId = Utils.parseInt((String)val.getValue(), (int)0);
                    if (parameterId > 0 && (contractParameterGroupAttr = (ContractParameterGroupAttr)((ClientContext)DocumentsPatternPanel.this.getContext()).getDirectory(ContractParameterGroupAttr.class).get(parameterId)) != null) {
                        paramName = contractParameterGroupAttr.getTitle();
                    }
                } else if (type.equals((Object)DocumentVariableType.DATE) && (dt = TimeUtils.parseDate((String)val.getValue(), (String)"dd.MM.yyyy")) != null) {
                    paramName = TimeUtils.format((Date)dt, (String)val.getAdditionalParam());
                }
                return paramName;
            }
            return super.getValue((Object)val, column);
        }
    }

    class DocumentTableModel
    extends BGTableModel<DocumentTable> {
        public DocumentTableModel() {
            super("tables");
        }

        protected void initColumns() {
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", -1, 120, 120, "identifier", false);
            this.addColumn("\u0418\u043c\u044f", -1, -1, -1, "title", true);
            this.addColumn("\u041c\u0435\u0442\u043e\u0434 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445", -1, 190, 200, "id");
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value");
        }

        public Object getValue(DocumentTable val, int column) throws Exception {
            if (column == 2) {
                return val.getExtractMethod().getTitle();
            }
            return super.getValue((Object)val, column);
        }
    }

    private class FileNameDocumentListener
    implements DocumentListener {
        private FileNameDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processTextUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processTextUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processTextUpdate(e);
        }

        private void processTextUpdate(DocumentEvent e) {
            SwingUtilities.invokeLater(() -> {
                Document doc = e.getDocument();
                try {
                    String text = doc.getText(0, doc.getLength());
                    DocumentsPatternPanel.this.downloadFileButton.setEnabled(!Utils.isBlankString((String)text));
                    DocumentsPatternPanel.this.deleteFileButton.setEnabled(!Utils.isBlankString((String)text));
                    DocumentsPatternPanel.this.openFileButton.setEnabled(!Utils.isBlankString((String)text));
                    DocumentsPatternPanel.this.chooseFileButton.setEnabled(Utils.isBlankString((String)text));
                }
                catch (BadLocationException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            });
        }
    }

    class TableRowTransferHandler
    extends TransferHandler {
        private static final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
        private DocumentPatternTableModel tableModel = null;

        public TableRowTransferHandler(DocumentPatternTableModel tableModel) {
            this.tableModel = tableModel;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(final JComponent c) {
            return new Transferable(){

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return true;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{localObjectFlavor};
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return ((BGUTable)c).getSelectedRow();
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            BGUTable table = (BGUTable)info.getComponent();
            for (RowSorter.SortKey sortKey : table.getRowSorter().getSortKeys()) {
                if (SortOrder.UNSORTED.equals((Object)sortKey.getSortOrder())) continue;
                if (ClientUtils.confirm((String)"\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432 \u0440\u0435\u0436\u0438\u043c \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432?", (String)"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435")) {
                    table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.UNSORTED)));
                    table.revalidate();
                }
                return false;
            }
            boolean b = info.isDrop() && info.isDataFlavorSupported(localObjectFlavor);
            table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
            return b;
        }

        @Override
        protected void exportDone(JComponent c, Transferable transferable, int act) {
            if (act == 2 || act == 0) {
                ((BGUTable)c).setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            try {
                JTable target = (JTable)info.getComponent();
                target.setCursor(Cursor.getPredefinedCursor(0));
                int indexFrom = (Integer)info.getTransferable().getTransferData(localObjectFlavor);
                int indexTo = ((JTable.DropLocation)info.getDropLocation()).getRow();
                DocumentPattern documentPattern = (DocumentPattern)this.tableModel.getSelectedRow();
                if (documentPattern != null) {
                    if (indexFrom != -1 && indexFrom > indexTo) {
                        this.tableModel.deleteRow(documentPattern);
                        this.tableModel.getRows().add(indexTo, documentPattern);
                        DocumentsPatternPanel.this.reorder();
                        return true;
                    }
                    if (indexFrom != -1 && indexFrom < indexTo) {
                        this.tableModel.deleteRow(documentPattern);
                        this.tableModel.getRows().add(indexTo - 1, documentPattern);
                        DocumentsPatternPanel.this.reorder();
                        return true;
                    }
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            return false;
        }
    }
}

