/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.JAXBUtils;

public class InetAccountingPeriod
extends Id
implements Cloneable {
    private int contractId;
    private Date dateFrom;
    private Date dateTo;
    private int userId;

    public InetAccountingPeriod() {
    }

    public InetAccountingPeriod(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute(name="cid")
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public boolean isActive() {
        Date now = new Date();
        return !(this.dateFrom != null && !now.after(this.dateFrom) || this.dateTo != null && !now.before(this.dateTo));
    }

    public String toString() {
        try {
            return this.id + ": " + TimeUtils.formatPeriodWithTime((Date)this.dateFrom, (Date)this.dateTo);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public InetAccountingPeriod clone() {
        try {
            return (InetAccountingPeriod)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

