/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess.create;

import java.util.Date;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AbstractNetflowLogParser;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.InetConnectionAutoRuntimeCreateSessions;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.inet.IpAddress;

class NetflowLogParser
extends AbstractNetflowLogParser {
    private static final Logger logger = LogManager.getLogger();
    private FlowAgent flowAgent;

    public NetflowLogParser(Setup setup, int deviceId, int moduleId, Accounting accounting) throws BGException {
        super(setup, deviceId, moduleId);
        HashSet<Integer> devices = new HashSet<Integer>();
        devices.add(this.deviceId);
        FlowAgentInterfaceSelector ifaceSelector = new FlowAgentInterfaceSelector(accounting, devices, 1, 2, 5, 3, 4);
        this.flowAgent = ifaceSelector.getAgentIdMap().get(this.deviceId);
    }

    @Override
    protected void processFlow(Data record, IpAddress srcAddress, IpAddress dstAddress, int direction, int port, int inputIface, int outputIface, int zoneDelta, Date hour) throws BGException {
        if (srcAddress.equals((Object)IpAddress.ZERO_ADDRESS) || record.milliseconds == 0L) {
            return;
        }
        long millis = record.milliseconds + (long)zoneDelta;
        if (this.flowAgent == null) {
            logger.error("flowAgent = null");
            return;
        }
        FlowAgentInterface iface = this.flowAgent.getInterface(hour.getTime(), millis, inputIface);
        if (iface == null) {
            logger.trace("Not found iface = " + inputIface);
            iface = this.flowAgent.defaultIface;
        }
        if (iface != null) {
            InetConnectionRuntime connectionRuntime = iface.getConnection(srcAddress, direction, hour.getTime(), millis);
            if (connectionRuntime != null) {
                InetConnectionAutoRuntimeCreateSessions connectionAutoRuntime = (InetConnectionAutoRuntimeCreateSessions)connectionRuntime;
                connectionAutoRuntime.setTrafficExist(true);
            } else {
                logger.trace("session was not found for " + srcAddress);
            }
        } else {
            logger.trace("Default iface not found");
        }
    }
}

