/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp.connection;

import ru.bitel.bgbilling.common.bean.IPUtils;

public class InetDhcpConnectionKey {
    public final int deviceId;
    public final int agentDeviceId;
    public final int circuitId;
    public final String mac;
    public final int ipAddress;

    public InetDhcpConnectionKey(int deviceId, int agentDeviceId, int circuitId, String mac, int ipAddress) {
        this.deviceId = deviceId;
        this.agentDeviceId = agentDeviceId;
        this.circuitId = circuitId;
        this.mac = mac;
        this.ipAddress = ipAddress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.agentDeviceId;
        result = 31 * result + this.circuitId;
        result = 31 * result + this.deviceId;
        result = 31 * result + this.ipAddress;
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InetDhcpConnectionKey)) {
            return false;
        }
        InetDhcpConnectionKey other = (InetDhcpConnectionKey)obj;
        if (this.agentDeviceId != other.agentDeviceId || this.circuitId != other.circuitId || this.deviceId != other.deviceId || this.ipAddress != other.ipAddress) {
            return false;
        }
        return !(this.mac == null ? other.mac != null : !this.mac.equals(other.mac));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.deviceId > 0) {
            sb.append("deviceId:").append(this.deviceId).append(';');
        }
        if (this.agentDeviceId > 0) {
            sb.append("agentDeviceId:").append(this.agentDeviceId).append(';');
        }
        if (this.circuitId > 0) {
            sb.append("circuitId:").append(this.circuitId).append(';');
        }
        if (this.mac != null) {
            sb.append("mac:").append(this.mac).append(';');
        }
        if (this.ipAddress != 0) {
            sb.append("ipAddress:").append(IPUtils.convertIpToString((int)this.ipAddress)).append(';');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

