/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import bitel.billing.server.contract.bean.Contract;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusSessionParams;

public class RadiusAccessRequestEvent
extends LocalEvent {
    private final int deviceId;
    private final int agentDeviceId;
    private final InetNas nas;
    private final Contract contract;
    private final InetServ inetServ;
    private final RadiusPacket request;
    private final RadiusPacket response;
    private final String username;
    private final String realm;
    private final int accessCode;
    private final int ipResourceId;

    public RadiusAccessRequestEvent(int moduleId, InetNas nas, int agentDeviceId, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, int ipResourceId) {
        super(moduleId, radiusSession.contract.getId(), 0);
        this.deviceId = nas.getId();
        this.agentDeviceId = agentDeviceId;
        this.nas = nas;
        this.contract = radiusSession.contract;
        this.inetServ = (InetServ)radiusSession.login;
        this.request = request;
        this.response = response;
        this.username = radiusSession.userName;
        this.realm = ((InetRadiusSessionParams)radiusSession.sessionParams).realm;
        this.accessCode = radiusSession.errorCode;
        this.ipResourceId = ipResourceId;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getAgentDeviceId() {
        return this.agentDeviceId;
    }

    public InetNas getNas() {
        return this.nas;
    }

    public Contract getContract() {
        return this.contract;
    }

    public InetServ getInetServ() {
        return this.inetServ;
    }

    public RadiusPacket getRequest() {
        return this.request;
    }

    public RadiusPacket getResponse() {
        return this.response;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    public int getIpResourceId() {
        return this.ipResourceId;
    }
}

