/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.ip;

import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpAddressRangeSet;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

class InetServRuntimeRangeSet
extends IpAddressRangeSet<InetServRuntime> {
    private static final Ranger<InetServRuntime, byte[]> addressRanger = new Ranger<InetServRuntime, byte[]>(){

        public byte[] getMinValue(InetServRuntime r) {
            return r.getInetServ().getAddressFrom();
        }

        public byte[] getMaxValue(InetServRuntime r) {
            return r.getInetServ().getAddressTo();
        }
    };

    protected InetServRuntimeRangeSet() {
        super(InetServRuntime.class, addressRanger, false, 1);
    }

    public InetServRuntime get(IpAddress address) {
        byte[] segmentKey = this.segmenter.segmentKey(address.address);
        IpAddress segment = new IpAddress(segmentKey);
        return (InetServRuntime)super.get((Object)segment, (Object)address.address);
    }

    public InetServRuntime get(IpAddress address, long millis) {
        byte[] segmentKey = this.segmenter.segmentKey(address.address);
        AddressMatcher matcher = new AddressMatcher(segmentKey, millis, null);
        return (InetServRuntime)super.get((Object)matcher, (Object)address.address, (Matcher)matcher);
    }

    public InetServRuntime get(IpAddress address, long millis, Matcher<InetServRuntime> matcher) {
        byte[] segmentKey = this.segmenter.segmentKey(address.address);
        AddressMatcher m = new AddressMatcher(segmentKey, millis, matcher);
        return (InetServRuntime)super.get((Object)m, (Object)address.address, (Matcher)m);
    }

    static final class AddressMatcher
    extends IpAddress
    implements Matcher<InetServRuntime> {
        private static final long serialVersionUID = 1L;
        private final long millis;
        private final Matcher<InetServRuntime> matcher;

        AddressMatcher(byte[] segmentKey, long millis, Matcher<InetServRuntime> matcher) {
            super(segmentKey);
            this.millis = millis;
            this.matcher = matcher;
        }

        public boolean matched(InetServRuntime x) {
            long dateToMillis = x.getDateToMillis();
            if (dateToMillis != 0L && dateToMillis < this.millis) {
                return false;
            }
            long dateFromMillis = x.getDateFromMillis();
            if (dateFromMillis != 0L && dateFromMillis > this.millis) {
                return false;
            }
            if (this.matcher != null) {
                return this.matcher.matched((Object)x);
            }
            return true;
        }
    }
}

