/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public class BalanceTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    public static final int MODE_GREATER_OR_EQUAL = 0;
    public static final int MODE_LESS = 1;
    private final int mode;
    private final BigDecimal delta;

    public BalanceTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.mode = parameterMap.getInt("mode", 0);
        BigDecimal delta = parameterMap.getBigDecimal("delta", null);
        if (delta != null && BigDecimal.ZERO.compareTo(delta) == 0) {
            delta = null;
        }
        this.delta = delta;
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, InetTariffContext context, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        ConvergenceBalance convergenceBalance = req.getConvergenceBalance();
        if (convergenceBalance == null) {
            return 0;
        }
        BigDecimal accountDelta = req.getAccountDelta();
        boolean isBalanceExceeds = accountDelta != null ? (this.delta != null ? convergenceBalance.isBalanceExceedsLimit(this.delta.add(accountDelta)) : convergenceBalance.isBalanceExceedsLimit(accountDelta)) : (this.delta != null ? convergenceBalance.isBalanceExceedsLimit(this.delta) : convergenceBalance.isBalanceExceedsLimit());
        switch (this.mode) {
            case 1: {
                return isBalanceExceeds ? 0 : 1;
            }
        }
        return isBalanceExceeds ? 1 : 0;
    }
}

