/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileToken;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class MobileTokenDao
extends AbstractIdDao<MobileToken> {
    public MobileTokenDao(Connection con, int moduleId) {
        super(con, moduleId, "mobile_tokens");
    }

    public int getCountTokenActive(int contractId) throws SQLException {
        int result = 0;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE contractId=? AND expiredDate>NOW()";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public List<MobileToken> listTokens(int contractId) throws SQLException {
        return this.list("contractId=?", null, new Object[]{contractId});
    }

    public void deleteExpiredTokens(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE contractId=? AND expiredDate<NOW()";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    public void deleteTokens(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE contractId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    protected MobileToken getFromRS(ResultSet rs) throws SQLException {
        MobileToken token = new MobileToken();
        token.setId(rs.getInt("id"));
        token.setContractId(rs.getInt("contractId"));
        token.setExpiredDate(rs.getTimestamp("expiredDate"));
        token.setCreatedDate(rs.getTimestamp("createdDate"));
        token.setUpdatedDate(rs.getTimestamp("updatedDate"));
        return token;
    }

    protected void updateImpl(MobileToken token) throws SQLException {
        Objects.requireNonNull(token);
        if (token.getContractId() < 0) {
            throw new BGRuntimeException("token.getContractId() < 0");
        }
        if (token.getId() <= 0) {
            String query = "INSERT INTO " + this.tableName + " SET contractId=?, expiredDate=?, createdDate=NOW()";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(1, token.getContractId());
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)token.getExpiredDate()));
                ps.executeUpdate();
                token.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

