/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.service;

import jakarta.jws.WebService;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractData;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.bgbilling.modules.mobile.common.bean.PushStatusType;
import ru.bitel.bgbilling.modules.mobile.common.service.MobileService;
import ru.bitel.bgbilling.modules.mobile.server.api.MobileApi;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobileContractDataDao;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobileContractNotificationDao;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mobile.common.service.MobileService")
public class MobileServiceImpl
extends AbstractService
implements MobileService {
    private MobileContractDataDao dataDao;
    private MobileContractNotificationDao notificationDao;

    private MobileContractDataDao getMobileDataDao() {
        if (this.dataDao == null) {
            this.dataDao = new MobileContractDataDao(this.getConnection(), this.moduleId);
        }
        return this.dataDao;
    }

    private MobileContractNotificationDao getNotificationDao() {
        if (this.notificationDao == null) {
            this.notificationDao = new MobileContractNotificationDao(this.getConnection(), this.moduleId);
        }
        return this.notificationDao;
    }

    public MobileContractData getMobileContractData(int contractId) throws BGException {
        return this.getMobileDataDao().getContractData(contractId);
    }

    public List<MobileContractNotification> contractNotifications(int contractId, Period periodSend, Boolean storable, Boolean notConfirm) throws BGException {
        return this.getNotificationDao().getContractNotificationList(contractId, periodSend, storable, notConfirm);
    }

    public void deleteContractNotification(int id) throws BGException {
        try {
            this.getNotificationDao().deleteNotification(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public MobileContractNotification sendPushNotification(MobileContractNotification notification) throws BGException {
        if (notification == null || notification.getContractId() < 1 || Utils.isBlankString((String)notification.getText())) {
            throw new BGIllegalArgumentException();
        }
        if (notification.getText().length() > 1024) {
            throw new BGMessageException("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f");
        }
        try (MobileApi mobileApi = new MobileApi((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId);
             ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            int contractId = notification.getContractId();
            if (!mobileApi.checkPossibilitySending(contractId)) {
                Contract contract = (Contract)contractDao.get(contractId);
                boolean checkPossibilitySending = true;
                if (contract.isSub() && (checkPossibilitySending = mobileApi.checkPossibilitySending(contract.getSuperCid()))) {
                    if (notification.getParams() == null) {
                        notification.setParams(new HashMap());
                    }
                    notification.getParams().put("subContractId", "" + contractId);
                    contractId = contract.getSuperCid();
                } else {
                    this.getLogger().error("contractId={}; contract.isSub()={}; checkPossibilitySending={}", new Object[]{contractId, contract.isSub(), checkPossibilitySending});
                    throw new BGException("\u0422\u043e\u043a\u0435\u043d\u0430 \u043d\u0435\u0442, \u043b\u0438\u0431\u043e \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0443 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439!", "contractNotPossibleSend");
                }
            }
            notification.setUserId(this.userId);
            notification.setDateSend(new Date());
            try {
                this.getNotificationDao().update(notification);
                this.getConnection().commit();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            notification.setContractId(contractId);
            PushStatusType status = mobileApi.sendPushNotification(notification);
            notification.setStatus(status);
            this.getNotificationDao().updateStatus(notification.getId(), status);
        }
        return notification;
    }
}

