/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.payonline.common.bean.Rebill;
import ru.bitel.bgbilling.modules.payonline.common.bean.RebillTransaction;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payonline.common.service.PayOnlineService;
import ru.bitel.bgbilling.modules.payonline.server.PayOnlineUtils;
import ru.bitel.bgbilling.modules.payonline.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillTransactionManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.payonline.server.event.PayonlineAutopaymentEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.payonline.common.service.PayOnlineService")
public class PayOnlineServiceImpl
extends AbstractService
implements PayOnlineService {
    private static final char POST_DELIM = '&';
    private static final String CURRENCY = "RUB";

    public SearchResult<Transaction> searchTransactions(int contractId, String contractTitle, String transactionStatus, PeriodWithTime period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
        transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, contractId, contractTitle, transactionStatus);
        return searchResult;
    }

    public void addTransactions(String transactions) throws Exception {
        Connection con = this.getConnection();
        boolean autoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        PayOnlineUtils payOnlineUtils = new PayOnlineUtils(con, this.moduleId);
        if (Utils.notBlankString((String)transactions)) {
            TransactionManager transactionManager = new TransactionManager(con, this.moduleId);
            Document paymentsDoc = XMLUtils.parseDocument((byte[])transactions.getBytes("UTF-8"));
            for (Element paymentElement : XMLUtils.selectElements((Node)paymentsDoc, (String)"//payment")) {
                Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setTransactionId(XMLUtils.getAttribute((Element)paymentElement, (String)"trans_id"))).setContractId(Integer.valueOf(XMLUtils.getAttribute((Element)paymentElement, (String)"cid")).intValue())).setTransactionDate(TimeUtils.parseDate((String)XMLUtils.getAttribute((Element)paymentElement, (String)"datetime"), (String)"dd.MM.yyyy HH:mm:ss"))).setSum(new BigDecimal(XMLUtils.getAttribute((Element)paymentElement, (String)"summa")))).build();
                transactionManager.update(transaction);
                payOnlineUtils.pay(transaction, 0);
                ServerUtils.commitConnection((Connection)con);
            }
        }
        con.setAutoCommit(autoCommit);
    }

    public void deleteTransactions(List<Integer> transactionIds) throws Exception {
        if (transactionIds != null && !transactionIds.isEmpty()) {
            Connection con = this.getConnection();
            TransactionManager transactionManager = new TransactionManager(con, this.moduleId);
            for (Integer id : transactionIds) {
                ChargeDao chargeDAO = new ChargeDao(con);
                Transaction transaction = (Transaction)transactionManager.get(id);
                transactionManager.delete(transaction.getId());
                Charge charge = Charge.builder().setDate(new Date()).setSum(transaction.getSum()).setContractId(transaction.getContractId()).setTimeChange(new Date()).setTypeId(this.getModuleSetup().getInt("refund.charge.typeid", -1)).setPayback(false).setUserId(0).setComment(this.getModuleSetup().get("refund.charge.comment", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u0435\u043d\u0435\u0433 \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b Payonline \u043f\u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 " + transaction.getTransactionId())).build();
                chargeDAO.update((Object)charge);
                int chargeId = transactionManager.getPaymentIdToTransaction(transaction.getId(), 1);
                Charge commission = (Charge)chargeDAO.get(chargeId);
                Payment payment = null;
                if (commission != null) {
                    payment = Payment.builder().setDate(new Date()).setTypeId(this.getModuleSetup().getInt("refund.payment.typeid", -1)).setSum(commission.getSum()).setContractId(transaction.getContractId()).setTimeChange(new Date()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId()) + "_refund").setComment(this.getModuleSetup().get("refund.payment.comment", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436 \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b Payonline \u043f\u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 " + transaction.getTransactionId())).build();
                    new PaymentDao(con).update((Object)payment);
                }
                transactionManager.deletePaymentToTransaction(transaction.getId());
                try (BalanceUtils bu = new BalanceUtils(con);){
                    bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                }
                EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
                if (payment != null) {
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                }
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 4, charge.getSum()));
            }
        }
    }

    public List<IdTitle> getContractTitles(List<Integer> contractIds) throws Exception {
        ArrayList<IdTitle> idTitles = new ArrayList<IdTitle>();
        if (idTitles != null && !idTitles.isEmpty()) {
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                idTitles.addAll(contractDao.getContracts(contractIds).stream().map(IdTitle::toIdTitle).toList());
            }
        }
        return idTitles;
    }

    public Rebill getContractRebillTransaction(int contractId) throws Exception {
        try (RebillManager rebillManager = new RebillManager(this.getConnection(), this.moduleId);){
            Rebill rebill = rebillManager.getTransactionByCid(contractId);
            return rebill;
        }
    }

    public void deleteContractRebillTransaction(int rebillTransactionId) throws Exception {
        try (RebillManager rebillManager = new RebillManager(this.getConnection(), this.moduleId);){
            rebillManager.delete(rebillTransactionId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public SearchResult<RebillTransaction> searchRebillTransactions(String result, PeriodWithTime period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        RebillTransactionManager rebillTransactionManager = new RebillTransactionManager(this.getConnection(), this.moduleId);
        searchResult.setList(rebillTransactionManager.getList(period, "result=?", result));
        rebillTransactionManager.close();
        return searchResult;
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws Exception {
        return null;
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws Exception {
        AutopaymentManager autopaymentManager;
        Autopayment autopayment;
        if (contractId > 0 && (autopayment = (autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId)).getCurrentAutopayment(contractId)) != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
            EventProcessor.getInstance().publish((Event)new PayonlineAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
        }
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> urlHolder, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws Exception {
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (mode != null) {
            mode.value = "redirect";
        }
        if (urlHolder == null) {
            throw new BGIllegalAccessException();
        }
        ModuleSetup moduleSetup = this.getModuleSetup();
        if (moduleSetup.getInt("commission.type", 0) == 2) {
            BigDecimal percent = moduleSetup.getBigDecimal("commission.percent", BigDecimal.ZERO).add(new BigDecimal(100)).divide(new BigDecimal(100));
            amount = amount.multiply(percent);
        }
        BigDecimal minSumma = moduleSetup.getBigDecimal("min.summa", new BigDecimal(100));
        BigDecimal maxSumma = moduleSetup.getBigDecimal("max.summa", new BigDecimal(3000));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("minAmount", Utils.formatBigDecimalSumm((BigDecimal)minSumma));
        dataMap.put("maxAmount", Utils.formatBigDecimalSumm((BigDecimal)maxSumma));
        String uniq = moduleSetup.get("rebillUnique", "");
        String orderId = contractId + (String)(uniq.equals("") ? "" : "_" + uniq) + "_" + System.currentTimeMillis() + "_0";
        if (amount.compareTo(BigDecimal.ZERO) <= 0 || amount.compareTo(minSumma) < 0 || amount.compareTo(maxSumma) > 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
        }
        String merchantId = moduleSetup.get("merchant.id", "");
        String privateSecKey = moduleSetup.get("private.security.key", "");
        String payOnlineUrl = moduleSetup.get("pay.online.url", "");
        if (Utils.isBlankString((String)merchantId) || Utils.isBlankString((String)privateSecKey) || Utils.isBlankString((String)payOnlineUrl)) {
            throw new BGMessageException("\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e!");
        }
        Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
        String returnUrl = (String)params.get("resultUrl");
        try {
            if (Utils.isBlankString((String)returnUrl)) {
                returnUrl = moduleSetup.get("redirect.url", null);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        try {
            StringBuilder url = new StringBuilder(150);
            url.append(payOnlineUrl);
            url.append("?");
            String sb = "MerchantId=" + merchantId + "&";
            sb = sb + "OrderId=" + orderId + "&";
            sb = sb + "Amount=" + Utils.formatBigDecimal((BigDecimal)amount, (int)2) + "&";
            sb = sb + "Currency=RUB&";
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] digest = md5.digest((sb + "PrivateSecurityKey=" + privateSecKey).getBytes());
            sb = sb + "SecurityKey=" + Utils.bytesToHexString((byte[])digest).toLowerCase();
            url.append(sb);
            url.append('&');
            url.append("ReturnUrl=");
            url.append(URLEncoder.encode(returnUrl, "UTF-8"));
            urlHolder.value = url.toString();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        if (paramsHolder != null) {
            paramsHolder.value = new MapHolder(dataMap);
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
    }
}

