/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.tariff.tree;

import java.math.BigDecimal;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class CostTariffTreeNode
extends DefaultTariffTreeNode {
    private BigDecimal cost;
    private String operation;

    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map dataHash = this.getDataInHash();
        this.cost = Utils.parseBigDecimal((String)((String)dataHash.get("cost")), null);
        this.operation = dataHash.getOrDefault("operation", "=");
    }

    public void processRequest(TariffRequest request) {
        if (this.cost != null) {
            BigDecimal outCost = BigDecimal.ZERO;
            BigDecimal inCost = (BigDecimal)request.getResponseParam("cost");
            switch (this.operation) {
                case "+": {
                    outCost = (inCost == null ? BigDecimal.ZERO : inCost).add(this.cost);
                    break;
                }
                case "-": {
                    outCost = (inCost == null ? BigDecimal.ZERO : inCost).subtract(this.cost);
                    break;
                }
                case "*": {
                    outCost = (inCost == null ? BigDecimal.ZERO : inCost).multiply(this.cost);
                    break;
                }
                case "=": {
                    outCost = this.cost;
                }
            }
            request.setResponseParam("cost", (Object)outCost);
        }
    }
}

