/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code.importer;

import au.com.bytecode.opencsv.CSVReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.server.bean.code.CostMapItemReader;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class CostMapItemFullFileWithPrefixReader
implements CostMapItemReader {
    @Override
    public List<VoiceCostMapItem> getGeocodesFromString(String importString, String result, int costMapId, Period period) {
        ArrayList<VoiceCostMapItem> resultList = new ArrayList<VoiceCostMapItem>();
        try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(new ByteArrayInputStream(importString.getBytes(StandardCharsets.UTF_8))), ',');){
            List inDataMg = csvReader.readAll();
            for (CharSequence[] row : inDataMg) {
                String[] cody;
                String dest = row[0].trim().replaceAll("\t", " ");
                String cost = row[3].trim().replaceAll("\t", " ").replaceAll(",", ".");
                String codyStr = row[2].trim().replaceAll("\t", " ");
                String codDEF = row[1].trim().replaceAll("\t", " ");
                for (String codDiapazon : cody = codyStr.split(",")) {
                    String from;
                    String to;
                    ArrayList<String> codes = new ArrayList<String>();
                    String[] split = codDiapazon.split("-");
                    if (split.length == 1) {
                        from = to = split[0];
                    } else {
                        if (split.length != 2) continue;
                        from = split[0];
                        to = split[1];
                    }
                    from = from.trim();
                    to = to.trim();
                    this.addPrefixesDeep(String.join((CharSequence)",", row), from, to, codDEF, codes);
                    for (String cod : codes) {
                        VoiceCostMapItem item = new VoiceCostMapItem();
                        item.setCostMapId(costMapId);
                        item.setCode(cod.trim());
                        item.setDestinationTitle(dest);
                        item.setItemCost(Utils.parseBigDecimal((String)cost, (BigDecimal)BigDecimal.ZERO));
                        item.setDateFrom(period.getDateFrom());
                        item.setDateTo(period.getDateTo());
                        resultList.add(item);
                    }
                }
            }
        }
        catch (IOException | BGException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    private void addPrefixesDeep(String line, String from, String to, String pref, List<String> out) throws UnsupportedEncodingException, IOException, BGException {
        if (from.length() != to.length()) {
            throw new BGException("Wrong range in string:" + line);
        }
        int firstNonEqualIdx = this.findFirstNonEqual(from, to);
        int lastNonZeroIndexInFrom = this.findLastIndexOfNotChar(from, '0');
        int lastNotNineIndexInTo = this.findLastIndexOfNotChar(to, '9');
        this.addPrefixesTailFrom(from, pref, out, firstNonEqualIdx, lastNonZeroIndexInFrom);
        this.addPrefixesForFirstNonEqual(from, to, pref, out, firstNonEqualIdx, lastNonZeroIndexInFrom, lastNotNineIndexInTo);
        this.addPrefixesTailTo(to, pref, out, firstNonEqualIdx, lastNotNineIndexInTo);
    }

    private int findFirstNonEqual(String from, String to) {
        int firstNonEqualIdx = from.length();
        for (int i = 0; i < from.length() && i < to.length(); ++i) {
            if (from.charAt(i) == to.charAt(i)) continue;
            firstNonEqualIdx = i;
            break;
        }
        return firstNonEqualIdx;
    }

    private void addPrefixesForFirstNonEqual(String from, String to, String pref, List<String> out, int firstNonEqualIdx, int lastNonZeroIndexInFrom, int lastNotNineIndexInTo) throws IOException, UnsupportedEncodingException {
        if (firstNonEqualIdx < 0) {
            return;
        }
        if (firstNonEqualIdx == from.length()) {
            this.write(pref, from, out);
            return;
        }
        char fromCh = from.charAt(firstNonEqualIdx);
        char toCh = to.charAt(firstNonEqualIdx);
        char ch = fromCh;
        if (lastNonZeroIndexInFrom > firstNonEqualIdx) {
            ch = (char)(ch + '\u0001');
        }
        String pref1 = from.substring(0, firstNonEqualIdx);
        if (fromCh == '0' && toCh == '9' && lastNotNineIndexInTo <= firstNonEqualIdx && lastNonZeroIndexInFrom <= firstNonEqualIdx) {
            this.write(pref, pref1, out);
            return;
        }
        while (ch < toCh) {
            this.write(pref, pref1 + ch, out);
            ch = (char)(ch + '\u0001');
        }
        if (lastNotNineIndexInTo <= firstNonEqualIdx) {
            this.write(pref, pref1 + ch, out);
        }
    }

    private void write(String pref, String number, List<String> out) throws IOException, UnsupportedEncodingException {
        String outStr = pref + number;
        out.add(outStr);
    }

    private void addPrefixesTailFrom(String number, String pref, List<String> out, int firstNonEqualIdx, int lastNonZeroIndexInFrom) throws IOException, UnsupportedEncodingException {
        for (int i = lastNonZeroIndexInFrom; i > firstNonEqualIdx; --i) {
            String s = number.substring(0, i);
            char ch = number.charAt(i);
            if (lastNonZeroIndexInFrom > i) {
                ch = (char)(ch + '\u0001');
            }
            while (ch <= '9') {
                this.write(pref, s + ch, out);
                ch = (char)(ch + '\u0001');
            }
        }
    }

    private void addPrefixesTailTo(String number, String pref, List<String> out, int firstNonEqualIdx, int lastNotNineIndex) throws IOException, UnsupportedEncodingException {
        for (int i = lastNotNineIndex; i > firstNonEqualIdx; --i) {
            String s = number.substring(0, i);
            char toCh = number.charAt(i);
            for (char ch = '0'; ch < toCh; ch = (char)(ch + '\u0001')) {
                this.write(pref, s + ch, out);
            }
            if (lastNotNineIndex != i) continue;
            this.write(pref, s + toCh, out);
        }
    }

    private int findLastIndexOfNotChar(String prefix, char ch) {
        int lastIdx = -1;
        for (int i = prefix.length() - 1; i > 0; --i) {
            if (prefix.charAt(i) == ch) continue;
            lastIdx = i;
            break;
        }
        return lastIdx;
    }

    @Override
    public String getTitle() {
        return "CSV-multi (<dest>,<prefix>,<codes>,<cost>)";
    }
}

