/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Operator;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Report;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.AbonentReport;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.ActReport;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.InvoiceReport;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.ServiceReport;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.SovintelAbonentData;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Sovintel
extends Operator {
    @Override
    public void createAbonentSnapshot(Connection con, Date month) {
        try {
            this.clearSnapshot(con, month);
            PreparedStatement psInsert = this.getInsertSnapshotPs(con, month);
            for (SovintelAbonentData data : new SovintelAbonentData().extractData(con, this, month, null)) {
                psInsert.setInt(2, data.contractId);
                this.insertParam(psInsert, "contractTitle", data.contractTitle);
                this.insertParam(psInsert, "fullName", data.fullName);
                this.insertParam(psInsert, "jurStatus", data.jurStatus);
                this.insertParam(psInsert, "date1", TimeUtils.formatDate((Date)data.date1));
                this.insertParam(psInsert, "date2", TimeUtils.formatDate((Date)data.date2));
                this.insertParam(psInsert, "jurAddress", data.jurAddress);
                this.insertParam(psInsert, "inn", data.inn);
                this.insertParam(psInsert, "kpp", data.kpp);
                this.insertParam(psInsert, "countryCode", data.countryCode);
                this.insertParam(psInsert, "locationCode", data.locationCode);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void insertParam(PreparedStatement psInsert, String paramName, String paramValue) throws SQLException {
        psInsert.setString(3, paramName);
        psInsert.setString(4, Utils.maskNull((String)paramValue));
        psInsert.executeUpdate();
    }

    @Override
    public List<Report> getReportList(Date month, boolean hasSnapshot) {
        ArrayList<Report> result = new ArrayList<Report>();
        result.add(new AbonentReport(this, month, 1, false));
        if (hasSnapshot) {
            result.add(new AbonentReport(this, month, 2, true));
        }
        result.add(new InvoiceReport(this, month, 3));
        result.add(new ServiceReport(this, month, 5));
        result.add(new ActReport(this, month, 6));
        return result;
    }

    @Override
    public boolean needAbonentSnapshot() {
        return false;
    }

    @Override
    public void checkCorrectOperator() throws BGException {
        if (this.serviceList.size() <= 0) {
            throw new BGException("Phone oper " + this.id + " has empty service list!");
        }
    }
}

