package ru.bitel.bgbilling.modules.voice.dyn.mediator.md;
    
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.zip.ZipInputStream;

import ru.bitel.bgbilling.apps.voice.accounting.mediation.AbstractMediator;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordProcessor;
import ru.bitel.common.TimeUtils;
    
public abstract class MDBaseMediator
    extends AbstractMediator
{
    @Override
    public void readHourDataLog( VoiceRecordProcessor processor, Date hour )
        throws Exception
    {
        getLogger().debug( "readHourDataLog():" );

        LocalDateTime hourDateTime = TimeUtils.convertDateToLocalDateTime( hour );
        String hourDateTimeStr = hourDateTime != null ? DateTimeFormatter.ofPattern( "dd.MM.yyyy HH:mm" ).format( hourDateTime ) : "";
        String path = device.getLogPath();
        if ( getLogger().isDebugEnabled() )
        {
            getLogger().debug( "\thour = " + hourDateTimeStr );
            getLogger().debug( "\tpath = " + path );
        }

        String logPath = path + "/" + TimeUtils.format( hour, "yyyy/MM/dd_HH" ) + ".zip";
        if ( getLogger().isDebugEnabled() )
        {
            getLogger().debug( "logPath = " + logPath );
        }

        Path logFile = Paths.get( logPath );
        boolean exists = Files.exists( logFile );
        if ( getLogger().isDebugEnabled() )
        {
            getLogger().debug( "logFile exists => " + exists );
        }

        if ( !exists )
        {
            getLogger().warn( "log for " + hourDateTimeStr + " not exists" );
            return;
        }

        int columns = getColumns();
        try ( ZipInputStream zis = new ZipInputStream( new FileInputStream( logFile.toFile() ) ) )
        {
            zis.getNextEntry();
            BufferedReader reader = new BufferedReader( new InputStreamReader( zis ), 128 * 1024 );
            String line;
            while ( (line = reader.readLine()) != null )
            {
                String[] params = line.split( "\t" );
                if ( params.length == columns )
                {
                    getLogger().debug( "line = " + line );
                    processLine( processor, params );
                }
                else
                {
                    getLogger().warn( "Skip line: " + line );
                }
            }
        }
    }
    
    protected boolean skipLine( final String number )
    {
        if ( number.matches( "^46\\d{4,5}$" ) )
        {
            return true;
        }
        if ( number.matches( "^0\\d{1}$" ) )
        {
            return true;
        }
        return false;
    }

    protected VoiceRecord processLine( final VoiceRecordProcessor processor, final String[] params )
        throws InterruptedException
    {
        return null; 
    }

    protected int getColumns()
    {
        return 1;
    }
}
