/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogEditor;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotExportDialog;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotImportDialog;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.DialogComboBoxFilter;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.event.OpenDialogEditorEvent;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.DialogScheme;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.DialogSchemePanel;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.OpenDialogOnSchemeEvent;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class BotDialogConfigurePanel
extends BGUPanel
implements ItemListener {
    private BotConfigurePanel botConfigurePanel;
    private BGUList<BotDialog> dialogList;
    private JPanel dialogsPanel;
    private DialogComboBoxFilter<IdTitle> dialogGroups;
    private BotDialogEditor dialogEditor;

    protected BotDialogConfigurePanel(BotConfigurePanel botConfigurePanel) {
        this.botConfigurePanel = botConfigurePanel;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0414\u0438\u0430\u043b\u043e\u0433\u0438");
        this.dialogEditor = new BotDialogEditor(this.botConfigurePanel, this);
        this.dialogGroups = new DialogComboBoxFilter.DialogGroupComboBoxFilter(this, this.botConfigurePanel.getBotManagerService().getDialogGroups());
        this.dialogsPanel = new JPanel(new GridBagLayout());
        this.dialogsPanel.add((Component)this.getToolBar(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this.dialogsPanel.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b:"), new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogsPanel.add((Component)((Object)this.dialogGroups), new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogsPanel.add((Component)this.getDialogList(), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
        this.add(this.dialogsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.dialogEditor, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.showListDialogPanel(true);
        EventBus.subscribe(OpenDialogOnSchemeEvent.class, e -> this.editDialog(((OpenDialogOnSchemeEvent)e).getDialog()));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        IdTitle selectedGroup;
        if (e.getStateChange() == 1 && (selectedGroup = (IdTitle)this.dialogGroups.getSelectedItem()) != null) {
            try {
                if (selectedGroup.getId() == 0) {
                    this.dialogList.setData(this.botConfigurePanel.getBotManagerService().getDialogs());
                } else {
                    this.dialogList.setData(this.botConfigurePanel.getBotManagerService().getDialogsByGroupId(selectedGroup.getId()));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void showListDialogPanel(boolean showListDialogPanel) {
        this.dialogsPanel.setVisible(showListDialogPanel);
        this.dialogEditor.setVisible(!showListDialogPanel);
    }

    private JToolBar getToolBar() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> {
            switch (e.getActionCommand()) {
                case "newItem": {
                    this.dialogEditor.openEditor(null);
                    break;
                }
                case "editItem": {
                    this.editDialog();
                    break;
                }
                case "deleteItem": {
                    BotDialog selectedDialog = (BotDialog)this.dialogList.getSelectedValue();
                    if (selectedDialog == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043b\u043e\u0433 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                        break;
                    }
                    if (!ClientUtils.confirm((String)("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + selectedDialog.getTitle()), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0438\u0430\u043b\u043e\u0433\u0430")) break;
                    try {
                        for (BotDialogElement element : selectedDialog.getDialogElements()) {
                            element.getDialogIds().remove(selectedDialog.getId());
                        }
                        this.botConfigurePanel.getBotManagerService().updateDialogElements(selectedDialog.getDialogElements());
                        this.botConfigurePanel.getBotManagerService().deleteDialog(selectedDialog);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                    this.performAction("refresh");
                }
            }
        }, new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM});
        toolBar.setFloatable(false);
        toolBar.setOrientation(0);
        return toolBar;
    }

    private JScrollPane getDialogList() {
        JScrollPane scrollPaneWithDialogList = new JScrollPane();
        scrollPaneWithDialogList.setHorizontalScrollBarPolicy(31);
        this.dialogList = new BGUList();
        this.dialogList.setModel(new DefaultListModel());
        this.dialogList.setCellRenderer((ListCellRenderer)new DialogListCellRenderer());
        this.dialogList.setDragEnabled(true);
        this.dialogList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    BotDialogConfigurePanel.this.editDialog();
                } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
                    ActionListener actionListener = e -> {
                        new BotImportDialog(BotDialogConfigurePanel.this, BotDialogConfigurePanel.this.dialogList).showDialog();
                        BotDialogConfigurePanel.this.botConfigurePanel.performAction("refresh");
                    };
                    JPopupMenu popupMenu = new JPopupMenu();
                    if (BotDialogConfigurePanel.this.dialogList.getSelectedValue() != null) {
                        popupMenu.removeAll();
                        popupMenu.add("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0434\u0438\u0430\u043b\u043e\u0433\u0430").addActionListener(e -> {
                            BotDialog selectedDialog = (BotDialog)BotDialogConfigurePanel.this.dialogList.getSelectedValue();
                            if (selectedDialog != null) {
                                BotDialogConfigurePanel.this.botConfigurePanel.showAllElementsOfDialog(selectedDialog);
                            }
                        });
                        popupMenu.add("\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(actionListener);
                        popupMenu.add("\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> new BotExportDialog(BotDialogConfigurePanel.this, (BotDialog)BotDialogConfigurePanel.this.dialogList.getSelectedValue()).showDialog());
                        popupMenu.add("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0445\u0435\u043c\u0443 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432").addActionListener(e -> BotDialogConfigurePanel.this.showScheme());
                        popupMenu.show((Component)BotDialogConfigurePanel.this.dialogList, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        popupMenu.removeAll();
                        popupMenu.add("\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(actionListener);
                        popupMenu.show((Component)BotDialogConfigurePanel.this.dialogList, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    BotDialogConfigurePanel.this.clearSelectedDialogs();
                }
            }
        });
        scrollPaneWithDialogList.getViewport().add((Component)this.dialogList);
        return scrollPaneWithDialogList;
    }

    private void editDialog() {
        BotDialog selectedDialog = (BotDialog)this.dialogList.getSelectedValue();
        if (selectedDialog == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043b\u043e\u0433 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        this.editDialog(selectedDialog);
    }

    private void editDialog(BotDialog dialog) {
        EventBus.publish((Object)new OpenDialogEditorEvent(dialog, true));
        this.dialogEditor.openEditor(dialog);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ((DialogComboBoxFilter.DialogGroupComboBoxFilter)this.dialogGroups).setGroups(this.botConfigurePanel.getBotManagerService().getDialogGroups());
            this.dialogGroups.setSelectedIndex(0);
            this.dialogList.setData(this.botConfigurePanel.getBotManagerService().getDialogs());
        });
    }

    private void showScheme() {
        BotDialog selectedDialog = (BotDialog)this.dialogList.getSelectedValue();
        if (selectedDialog != null) {
            try {
                new DialogSchemePanel(new DialogScheme(this.botConfigurePanel.getBotManagerService().getDialogs(), selectedDialog)).showDialog();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    protected void showDialogsWithElement(BotDialogElement element) {
        if (element == null) {
            return;
        }
        int size = this.dialogList.getModel().getSize();
        for (int x = 0; x < size; ++x) {
            BotDialog dialog = (BotDialog)this.dialogList.getModel().getElementAt(x);
            if (!dialog.getDialogElements().contains(element)) continue;
            DialogListCellRenderer.dialogsForHighlight.add(dialog);
        }
        this.dialogList.revalidate();
        this.dialogList.repaint();
    }

    protected void clearSelectedDialogs() {
        DialogListCellRenderer.dialogsForHighlight.clear();
        this.dialogList.revalidate();
        this.dialogList.repaint();
    }

    private static final class DialogListCellRenderer
    implements ListCellRenderer<BotDialog> {
        static final List<BotDialog> dialogsForHighlight = new ArrayList<BotDialog>();

        private DialogListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends BotDialog> list, BotDialog dialog, int index, boolean isSelected, boolean cellHasFocus) {
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0);
            JPanel renderedPanel = new JPanel(new GridBagLayout());
            renderedPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            if (dialogsForHighlight.contains(dialog)) {
                renderedPanel.setBackground(Color.yellow);
            } else {
                renderedPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            }
            JLabel dialogTitle = new JLabel(dialog.getTitle());
            dialogTitle.setFont(new Font("SansSerif", 0, 22));
            renderedPanel.add((Component)dialogTitle, constraints);
            List elements = dialog.getDialogElements();
            JLabel elementsOfDialogCount = new JLabel("\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432: " + elements.size());
            elementsOfDialogCount.setFont(new Font("SansSerif", 2, 14));
            renderedPanel.add((Component)elementsOfDialogCount, constraints);
            JLabel dialogId = new JLabel("ID: " + dialog.getId());
            dialogId.setFont(new Font("SansSerif", 0, 11));
            renderedPanel.add((Component)dialogId, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            return renderedPanel;
        }
    }
}

