/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.service;

import bitel.billing.server.contract.bean.LimitChangeTask;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractLimitManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractLimitMovementDao;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvto;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvtoStatus;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitLog;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitMovement;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractSubPanelLog;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractSubPanelManage;
import ru.bitel.bgbilling.kernel.contract.limit.common.service.ContractLimitService;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.ContractLimitLogManager;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ChangeContractLimitEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractLimitUserLow;
import ru.bitel.bgbilling.kernel.event.events.LimitChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.limit.common.service.ContractLimitService")
public class ContractLimitServiceImpl
extends AbstractService
implements ContractLimitService {
    ContractDao contractDao = null;

    private ContractDao getContractDao() {
        return this.contractDao == null ? (this.contractDao = new ContractDao(this.getConnection(), this.userId)) : this.contractDao;
    }

    @Override
    public SearchResult<ContractLimitLog> searchContractLimitLogList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        new ContractLimitLogManager(this.getConnection()).searchContractLimitLog((SearchResult<ContractLimitLog>)searchResult, contractId);
        return searchResult;
    }

    @Override
    public SearchResult<ContractLimitAvto> searchContractLimitAvtoList(int contractId, String status, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page, sort);
        new LimitManager(this.getConnection()).searchContractLimitAvto((SearchResult<ContractLimitAvto>)searchResult, contractId, status);
        return searchResult;
    }

    @Override
    public void updateContractLimitPeriodGroupOperation(String contractIds, BigDecimal limit, int period) throws Exception {
        block3: {
            block2: {
                if (period <= 0) break block2;
                for (String contractId : contractIds.split(",")) {
                    this.updateContractLimitPeriod(Integer.parseInt(contractId.trim()), limit, period, "");
                }
                break block3;
            }
            if (period != 0) break block3;
            for (String contractId : contractIds.split(",")) {
                this.updateContractLimit(Integer.parseInt(contractId.trim()), limit, "");
            }
        }
    }

    @Override
    public void updateContractLimitPeriod(int contractId, BigDecimal limit, int period, String comment) throws Exception {
        if (contractId < 1 || period < 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 cid=" + contractId + "; period=" + period);
        }
        Contract contract = (Contract)this.getContractDao().get(contractId);
        LimitManager limitManager = new LimitManager(this.getConnection());
        if (contract != null) {
            ChangeContractLimitEvent event = new ChangeContractLimitEvent(contract.getId(), this.userId);
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString((String)event.getMessage())) {
                throw new BGMessageException(event.getMessage());
            }
            if (!event.isProcessed()) {
                BigDecimal currentLimit = contract.getBalanceLimit();
                BigDecimal newLimit = currentLimit.add(limit);
                limitManager.updateContractLimit(this.userId, newLimit, contractId, comment, period);
                this.context.publishAfterCommit(new SystemLimitChangedEvent(contractId, newLimit));
                this.context.publishAfterCommit(new LimitChangedEvent(contractId, newLimit));
                GregorianCalendar dt = new GregorianCalendar();
                ((Calendar)dt).add(6, period);
                LimitChangeTask task = new LimitChangeTask();
                task.setContractId(contractId);
                task.setDate(dt.getTime());
                task.setUserId(this.userId);
                task.setDeltaSum(limit);
                task.setStatus(ContractLimitAvtoStatus.ON);
                limitManager.addMoveTask(task);
            }
        }
    }

    @Override
    public void contractLimitMove(int contractId, BigDecimal amount, int days) throws Exception {
        ContractLimitParameters clp;
        LimitManager lm = new LimitManager(this.getConnection());
        ContractLimitManager clm = new ContractLimitManager(this.getConnection());
        Contract contract = (Contract)this.getContractDao().get(contractId);
        ChangeContractLimitEvent event = new ChangeContractLimitEvent(contract.getId(), -1);
        event = EventProcessor.getInstance().request(event);
        if (Utils.notBlankString((String)event.getMessage())) {
            throw new BGMessageException(event.getMessage());
        }
        if (!event.isProcessed() && (clp = clm.getContractLimitParameters(this.getSetup(), contract)) != null && amount.compareTo(BigDecimal.ZERO) > 0 && days > 0 && contract.getBalanceMode() == 1) {
            if (amount.compareTo(clp.getMinSumm()) < 0 || amount.compareTo(clp.getMaxSumm()) > 0) {
                throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + Utils.formatBigDecimalSumm((BigDecimal)clp.getMinSumm()) + " \u0434\u043e " + Utils.formatBigDecimalSumm((BigDecimal)clp.getMaxSumm()));
            }
            if (days < clp.getMinDays() || days > clp.getMaxDays()) {
                throw new BGMessageException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043d\u0435\u0439 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + Utils.formatBigDecimalSumm((BigDecimal)clp.getMinSumm()) + " \u0434\u043e " + Utils.formatBigDecimalSumm((BigDecimal)clp.getMaxSumm()));
            }
            if (contract.getBalanceLimit().subtract(amount).compareTo(clp.getMinLimit()) < 0) {
                throw new BGMessageException("\u041f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430 \u043d\u0438\u0436\u0435 " + Utils.formatBigDecimalSumm((BigDecimal)clp.getMinLimit()) + " \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
            }
            lm.lowLimit(contractId, amount, days);
            contract = (Contract)this.getContractDao().get(contractId);
            this.context.publishAfterCommit(new ContractLimitUserLow(this.userId, contractId, amount, days));
            this.context.publishAfterCommit(new SystemLimitChangedEvent(contractId, contract.getBalanceLimit()));
            this.context.publishAfterCommit(new LimitChangedEvent(contractId, contract.getBalanceLimit()));
        }
    }

    @Override
    public List<ContractLimitMovement> contractLimitMovementList(int contractId, Date dateFrom, Date dateTo) throws Exception {
        return new ContractLimitMovementDao(this.getConnection()).list(contractId, dateFrom, dateTo);
    }

    @Override
    public ContractLimitParameters contractLimitParametersGet(int contractId) throws Exception {
        Contract contract = (Contract)this.getContractDao().get(contractId);
        return new ContractLimitManager(this.getConnection()).getContractLimitParameters(this.getSetup(), contract);
    }

    @Override
    public BigDecimal contractLimitGet(int contractId) throws Exception {
        Contract contract = (Contract)this.getContractDao().get(contractId);
        return contract != null ? contract.getBalanceLimit() : null;
    }

    @Override
    public void cancelLimitChangeTask(int contractId, List<Integer> taskIds) throws Exception {
        new LimitManager(this.getConnection()).cancelMoveTask(contractId, taskIds);
    }

    @Override
    public void updateContractLimit(int contractId, BigDecimal limit, String comment) throws Exception {
        ChangeContractLimitEvent event = new ChangeContractLimitEvent(contractId, this.userId);
        event = EventProcessor.getInstance().request(event);
        if (Utils.notBlankString((String)event.getMessage())) {
            throw new BGMessageException(event.getMessage());
        }
        if (!event.isProcessed()) {
            LimitManager limitManager = new LimitManager(this.getConnection());
            List<LimitChangeTask> taskList = limitManager.getContractMoveTasks(contractId);
            for (LimitChangeTask task : taskList) {
                limitManager.deleteMoveTaskAndLog(task.getId(), task.getContractId(), task.getUserId());
            }
            limitManager.updateContractLimit(this.userId, limit, contractId, comment, 0);
            this.context.publishAfterCommit(new SystemLimitChangedEvent(contractId, limit));
            this.context.publishAfterCommit(new LimitChangedEvent(contractId, limit));
        }
    }

    @Override
    public boolean checkContractLimitUpdate(int contractId, Holder<Integer> amount) throws Exception {
        LimitManager limitManager = new LimitManager(this.getConnection());
        amount.value = limitManager.getContractMoveTasks(contractId).size();
        return this.getSetup().getBoolean("reject.limit.update", false);
    }

    @Override
    public BigDecimal getCurrentContractLimit(int contractId) throws Exception {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Contract contract = (Contract)contractDao.get(contractId);
            BigDecimal bigDecimal = contract != null ? contract.getBalanceLimit() : BigDecimal.ZERO;
            return bigDecimal;
        }
    }

    @Override
    public SearchResult<ContractSubPanelLog> searchContractLimitLog(int contractId, Page page, Period period, String[] sort) throws Exception {
        SearchResult searchResult = new SearchResult();
        List list = searchResult.getList();
        searchResult.setPage(page);
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)(period != null ? period.getDateFrom() : null));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)(period != null ? period.getDateTo() : null));
        LimitManager lm = new LimitManager(this.getConnection());
        for (LimitManager.UserLimitMove userLimitMove : lm.getUserLimitMove(contractId, date1, date2)) {
            ContractSubPanelLog log = new ContractSubPanelLog();
            log.setContractId(contractId);
            log.setDate1(userLimitMove.getDate1().getTime());
            log.setDate2(userLimitMove.getDate2().getTime());
            log.setSum(new BigDecimal(userLimitMove.getSumm()));
            switch (userLimitMove.getStatus()) {
                case 0: {
                    log.setStatus("\u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                    break;
                }
                case 1: {
                    log.setStatus("\u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                    break;
                }
                case 2: {
                    log.setStatus("\u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                    break;
                }
                default: {
                    log.setStatus("\u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043e");
                }
            }
            list.add(log);
        }
        return searchResult;
    }

    @Override
    public SearchResult<ContractSubPanelManage> searchContractLimitManage(int contractId, Page page, String[] sort) throws Exception {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setList(new LimitManager(this.getConnection()).getContractManage((SearchResult<ContractSubPanelManage>)searchResult, contractId));
        return searchResult;
    }

    @Override
    public void setContractLimitMode(int contractId, int mode) throws Exception {
        LimitManager limitManager = new LimitManager(this.getConnection());
        int currentMode = limitManager.getLimitMode(contractId);
        if (currentMode != mode) {
            new LimitManager(this.getConnection()).setLimitManageMode(this.userId, contractId, mode);
        }
    }
}

