/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.tv.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public class TvTariffRequest
extends AbstractTariffRequest<TvServiceCost> {
    private final int tvAccountId;
    private TariffModuleTreeSet.Entry tariffTreeSetEntry;
    Set<Integer> optionSet = new HashSet<Integer>(8);
    private int accessCode = AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
    private BigDecimal balance;
    private BigDecimal limit;
    private Boolean balanceInsufficient = null;
    private boolean ignoreBalanceInsufficient = true;

    public TvTariffRequest(int domainId, int moduleId, int contractId, List<Integer> contractLabelIds, int tvAccountId, long sessionId) {
        super(domainId, moduleId, contractId, contractLabelIds, sessionId, null);
        this.tvAccountId = tvAccountId;
    }

    public void setProductPeriodRuntimeList(ProductPeriodRuntimeList productPeriodRuntimeList) {
        this.productPeriodRuntimeList = productPeriodRuntimeList;
    }

    public void setContractProductPeriodRuntimeList(ProductPeriodRuntimeList contractProductPeriodRuntimeList) {
        this.contractProductPeriodRuntimeList = contractProductPeriodRuntimeList;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public TariffModuleTreeSet.Entry getTariffTreeSetEntry() {
        return this.tariffTreeSetEntry;
    }

    public void setTariffTreeSetEntry(TariffModuleTreeSet.Entry tariffTreeSetEntry) {
        this.tariffTreeSetEntry = tariffTreeSetEntry;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Set<Integer> getOptionSet() {
        return this.optionSet;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }

    public boolean isIgnoreBalanceInsufficient() {
        return this.ignoreBalanceInsufficient;
    }

    public void setIgnoreBalanceInsufficient(boolean ignoreBalanceInsufficient) {
        this.ignoreBalanceInsufficient = ignoreBalanceInsufficient;
    }

    public boolean isBalanceInsufficient() {
        if (this.balanceInsufficient == null) {
            if (this.balance == null || this.limit == null) {
                return false;
            }
            this.balanceInsufficient = this.balance.compareTo(this.limit) < 0;
        }
        return this.balanceInsufficient;
    }

    public BigDecimal getLimit() {
        return this.limit;
    }

    public void setLimit(BigDecimal limit) {
        this.limit = limit;
    }

    public long getProportionalPeriodTimeTo(Set<Integer> depends, long periodFrom, long periodTo, boolean serviceCostMap) {
        ProductPeriodRuntimeList.ProductPeriodItem item;
        int i;
        long result = 0L;
        if (serviceCostMap) {
            for (List serviceCostList : this.serviceCostMap.values()) {
                for (TvServiceCost serviceCost : serviceCostList) {
                    if (serviceCost.prolongation == 0 || serviceCost.getCost() == null || !depends.contains(serviceCost.getProductSpecRuntime().getProductSpec().getId()) || serviceCost.periodTimeTo.getTime() <= result || (result = serviceCost.periodTimeTo.getTime()) < periodTo) continue;
                    return 0L;
                }
            }
        }
        int size = this.contractProductPeriodRuntimeList.size();
        for (i = 0; i < size; ++i) {
            item = (ProductPeriodRuntimeList.ProductPeriodItem)this.contractProductPeriodRuntimeList.item(i);
            if ((result = this.getProportionalPeriod0(depends, periodFrom, result, item)) < periodTo) continue;
            return 0L;
        }
        if (this.productPeriodRuntimeList != null) {
            size = this.productPeriodRuntimeList.size();
            for (i = 0; i < size; ++i) {
                item = (ProductPeriodRuntimeList.ProductPeriodItem)this.productPeriodRuntimeList.item(i);
                if ((result = this.getProportionalPeriod0(depends, periodFrom, result, item)) < periodTo) continue;
                return 0L;
            }
        } else assert (this.tvAccountId == 0) : "account productPeriodRuntimeList == null";
        return result;
    }

    private long getProportionalPeriod0(Set<Integer> depends, long periodFrom, long result, ProductPeriodRuntimeList.ProductPeriodItem item) {
        if (!depends.contains(item.productSpecId)) {
            return result;
        }
        if (!(item.timeFrom > periodFrom && item.timeFrom != 0L || item.timeTo < periodFrom && item.timeTo != 0L || item.timeTo <= result)) {
            result = item.timeTo;
        }
        return result;
    }

    public Date getTarifficationTime() {
        if (this.serviceCost != null && ((TvServiceCost)this.serviceCost).getProductItem() != null && ((TvServiceCost)this.serviceCost).getProductItem().productPeriodActivationTime != null) {
            if (!((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.after(((TvServiceCost)this.serviceCost).getProductItem().productPeriodActivationTime) && !((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeTo.before(((TvServiceCost)this.serviceCost).getProductItem().productPeriodActivationTime)) {
                return ((TvServiceCost)this.serviceCost).getProductItem().productPeriodActivationTime;
            }
            if (!((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.after(((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeTo)) {
                return ((TvServiceCost)this.serviceCost).getProductItem().productPeriodActivationTime;
            }
            return this.getTime().getTime();
        }
        return this.getTime().getTime();
    }

    public long getTarifficationTimeMillis(TvTariffContext ctx) {
        switch (ctx.getTariffMode()) {
            case realtime: 
            case scheduler: {
                assert (ctx.isProlongation());
                if (this.serviceCost == null) {
                    return this.getTime().getTimeInMillis();
                }
                if (((TvServiceCost)this.serviceCost).periodTimeFrom != null) {
                    return ((TvServiceCost)this.serviceCost).periodTimeFrom.getTime();
                }
                if (((TvServiceCost)this.serviceCost).getProductItem() != null && ((TvServiceCost)this.serviceCost).getProductItem().activationTime != null) {
                    if (((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.after(((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeTo) && ((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.before(((TvServiceCost)this.serviceCost).getProductItem().activationTime)) {
                        return ((TvServiceCost)this.serviceCost).getProductItem().activationTime.getTime();
                    }
                    return this.getTime().getTimeInMillis();
                }
                return this.getTime().getTimeInMillis();
            }
            case precalculate: {
                return this.getTime().getTimeInMillis();
            }
        }
        if (this.serviceCost == null || ((TvServiceCost)this.serviceCost).getProductItem() == null || ((TvServiceCost)this.serviceCost).getProductItem().activationTime == null) {
            return this.getTime().getTimeInMillis();
        }
        if (!((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.after(((TvServiceCost)this.serviceCost).getProductItem().activationTime) && !((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeTo.before(((TvServiceCost)this.serviceCost).getProductItem().activationTime)) {
            return ((TvServiceCost)this.serviceCost).getProductItem().activationTime.getTime();
        }
        if (((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.after(((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeTo) && ((TvServiceCost)this.serviceCost).getProductItem().productPeriodTimeFrom.before(((TvServiceCost)this.serviceCost).getProductItem().activationTime)) {
            return ((TvServiceCost)this.serviceCost).getProductItem().activationTime.getTime();
        }
        return this.getTime().getTimeInMillis();
    }
}

