/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.phone.server.action.ActionMailDispatch;
import ru.bitel.bgbilling.modules.phone.server.action.ActionReportSession;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.bgbilling.modules.phone.server.bean.Session;
import ru.bitel.bgbilling.modules.phone.server.bean.SessionDetail;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionReportServiceSession
extends ActionMailDispatch {
    @Override
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        super.doAction();
        if (this.html || this.showAll) {
            this.page.setPageSize(-1);
        }
        if (Utils.isEmptyString((String)this.items)) {
            StringBuilder sb = new StringBuilder();
            List<ClientItem> item = new ClientItemManager(this.con, this.mid).getItemList(this.cid, 1, false, 0);
            for (ClientItem i : item) {
                sb.append(i.getId());
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                this.items = sb.toString();
            } else {
                this.items = null;
            }
        }
        ReportManager rm = new ReportManager(this.con, this.mid);
        PagedList<SessionDetail<SessionDetail<Session>>> sessions = rm.getSessionDetailList(this.cid, this.items, this.date1, this.date2, this.type, this.noFree, this.page, 0, 0);
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (this.html) {
            String ext;
            String xsl;
            Thread.currentThread().setPriority(1);
            this.request.setAttribute("contentType", (Object)"binary");
            String email = this.request.getParameter("email");
            Element sessionsEl = this.createElement(this.rootNode, "sessions");
            this.setPageAttribute(sessionsEl, sessions.page);
            sessionsEl.setAttribute("count", String.valueOf(sessions.records));
            sessionsEl.setAttribute("total_number", String.valueOf(sessions.records));
            sessionsEl.setAttribute("total_cost", Utils.formatCost((BigDecimal)((SessionDetail)sessions.total).getTotalCost()));
            sessionsEl.setAttribute("total_time", String.valueOf(((SessionDetail)sessions.total).getTotalTime()));
            sessionsEl.setAttribute("total_time_round", String.valueOf(((SessionDetail)sessions.total).getTotalTimeRound()));
            this.rootNode.setAttribute("action", "DispatchSession");
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            Iterator iter = sessions.list.iterator();
            params.put("beans", new Iter.PublicIter(iter));
            params.put("lines", new ActionReportSession.CSVLine(null, format));
            params.put("size", new Iter.BeanNodeList(sessions.list.size()));
            params.put("format", format);
            params.put("formatDate", new SimpleDateFormat("dd.MM.yyyy"));
            params.put("formatTime", new SimpleDateFormat("HH:mm:ss"));
            if (!this.csv) {
                xsl = this.moduleSetup.get("phone.login.service.sessions", "phone_login_service_sessions.xsl");
                ext = ".html";
            } else {
                xsl = this.moduleSetup.get("phone.login.service.sessions.csv", "phone_login_service_sessions_csv.xsl");
                ext = ".csv";
            }
            String contentType = !this.csv ? "text/html" : "application/csv";
            ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
            Contract contract = (Contract)contractDao.get(this.cid);
            contractDao.close();
            sessionsEl.setAttribute("contractTitle", contract.getTitle());
            sessionsEl.setAttribute("comment", contract.getComment());
            sessionsEl.setAttribute("date1", TimeUtils.formatDate((Calendar)this.date1));
            sessionsEl.setAttribute("date2", TimeUtils.formatDate((Calendar)this.date2));
            sessionsEl.setAttribute("type", String.valueOf(this.type));
            String fileName = (String)(contract != null ? contract.getTitle() + "_" : "") + "detail_" + this.date1.get(1) + "_" + (this.date1.get(2) + 1);
            if (Utils.isBlankString((String)email)) {
                XSLManager.getInstance().transformToResponse(this.response, xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), params, contentType, fileName + ext, this.zip);
            } else {
                XSLManager.getInstance().transformAndSend(xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), params, contentType, fileName + ext, this.zip, email, null);
                try {
                    if (this.response != null) {
                        String CHARSET = "UTF-8";
                        this.response.getOutputStream().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<data status=\"ok\"/>".getBytes("UTF-8"));
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        } else {
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            this.setPageAttribute(table, sessions.page);
            table.setAttribute("count", String.valueOf(sessions.records));
            table.setAttribute("total_number", String.valueOf(sessions.records));
            table.setAttribute("total_cost", Utils.formatCost((BigDecimal)((SessionDetail)sessions.total).getTotalCost()));
            float time = ((SessionDetail)sessions.total).getTotalTime();
            table.setAttribute("total_time", Utils.formatSessionTime((int)((SessionDetail)sessions.total).getTotalTime()) + " [" + Math.round(time / 60.0f) + "]");
            time = ((SessionDetail)sessions.total).getTotalTimeRound();
            table.setAttribute("total_time_round", Utils.formatSessionTime((int)((SessionDetail)sessions.total).getTotalTimeRound()) + " [" + Math.round(time / 60.0f) + "]");
            for (SessionDetail serviceSessions : sessions.list) {
                Element service = this.createElement(data, "row");
                service.setAttribute("id", "\u0423\u0441\u043b\u0443\u0433\u0430: " + serviceSessions.getTitle());
                service.setAttribute("colspan", "1");
                for (SessionDetail aonSessions : serviceSessions.getList()) {
                    Element item = this.createElement(data, "row");
                    item.setAttribute("id", "\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0410: " + aonSessions.getTitle());
                    item.setAttribute("colspan", "1");
                    for (Session s : aonSessions.getList()) {
                        Element sess = this.createElement(data, "row");
                        sess.setAttribute("id", String.valueOf(s.getId()));
                        sess.setAttribute("cdr_id", String.valueOf(s.getCdrId()));
                        sess.setAttribute("hour", format.format((Object)s.getHour()));
                        sess.setAttribute("item_id", String.valueOf(s.getClientItemId()));
                        sess.setAttribute("item", s.getClientItem());
                        sess.setAttribute("dest", s.getDestination());
                        sess.setAttribute("dest_id", String.valueOf(s.getDestCode()));
                        sess.setAttribute("session_start", TimeUtils.format((Date)s.getSessionStart(), (String)"dd.MM.yyyy HH:mm:ss"));
                        sess.setAttribute("session_time", Utils.formatSessionTime((int)s.getSessionTime()));
                        sess.setAttribute("session_time_round", Utils.formatSessionTime((int)s.getSessionTimeRound()));
                        sess.setAttribute("session_cost", Utils.formatSessionCost((BigDecimal)s.getSessionCost()));
                        sess.setAttribute("from164", s.getFromNumber164());
                        sess.setAttribute("to164", s.getToNumber164());
                        sess.setAttribute("from", s.getFromNumber());
                        sess.setAttribute("to", s.getToNumber());
                    }
                    StringBuilder sb = new StringBuilder(100);
                    sb.append("\u0418\u0442\u043e\u0433\u043e \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443: \u043a\u043e\u043b-\u0432\u043e ");
                    sb.append(aonSessions.getTotalNumber());
                    sb.append(", \u0441\u0443\u043c\u043c\u0430 ");
                    sb.append(Utils.formatCost((BigDecimal)aonSessions.getTotalCost()));
                    sb.append(", \u043e\u043a\u0440. \u0434\u043b\u0438\u0442. (\u043c\u0438\u043d) ");
                    time = aonSessions.getTotalTimeRound();
                    sb.append(Math.round(time / 60.0f));
                    item = this.createElement(data, "row");
                    item.setAttribute("id", sb.toString());
                    item.setAttribute("colspan", "1");
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("\u0418\u0442\u043e\u0433\u043e \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0435: \u043a\u043e\u043b-\u0432\u043e ");
                sb.append(serviceSessions.getTotalNumber());
                sb.append(", \u0441\u0443\u043c\u043c\u0430 ");
                sb.append(Utils.formatCost((BigDecimal)serviceSessions.getTotalCost()));
                sb.append(", \u043e\u043a\u0440. \u0434\u043b\u0438\u0442. (\u043c\u0438\u043d) ");
                time = serviceSessions.getTotalTimeRound();
                sb.append(Math.round(time / 60.0f));
                service = this.createElement(data, "row");
                service.setAttribute("id", sb.toString());
                service.setAttribute("colspan", "1");
            }
        }
    }
}

