/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntime;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

public class DomainFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private Set<Integer> domainIds;
    private List<AtomicReference<DomainRuntime>> domains;

    @Override
    public void init(String data, int deep, int nodeID) {
        super.init(data, deep, nodeID);
        Map<String, String> values = this.getDataInHash();
        this.domainIds = new HashSet<Integer>(Utils.toIntegerList(Utils.maskNull(values.get("domainIds"))));
        this.domains = new ArrayList<AtomicReference<DomainRuntime>>(this.domainIds.size());
        try {
            DomainRuntimeMap domainRuntimeMap = DomainRuntimeMap.getInstance();
            for (Integer domainId : this.domainIds) {
                AtomicReference ref = domainRuntimeMap.getRef(domainId.intValue());
                if (ref == null) continue;
                this.domains.add(ref);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private boolean check(String tariffOptionAccepted, Integer domainId) {
        if (this.domainIds.size() == 0) {
            if (tariffOptionAccepted == null) {
                return true;
            }
        } else if (tariffOptionAccepted != null) {
            return false;
        }
        if (this.domainIds.contains(domainId)) {
            return true;
        }
        for (AtomicReference<DomainRuntime> ref : this.domains) {
            DomainRuntime domainRuntime = ref.get();
            if (domainRuntime == null || !domainRuntime.getDescendantIds().contains(domainId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processRequest(TariffRequest request) {
        Integer domainId;
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
            return;
        }
        String paramName = "dmn_f_a_" + this._parent.getId();
        String tariffOptionAccepted = (String)request.getResponseParam(paramName);
        if (this.check(tariffOptionAccepted, domainId = (Integer)request.getRequestParam("domainId"))) {
            this.processForChilds(request);
            request.setResponseParam(paramName, "true");
        }
    }
}

