/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.IPResourceCategory;
import bitel.billing.server.admin.resource.bean.ResourceCategoryManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class IPResourceCategoryManager
extends ResourceCategoryManager<IPResourceCategory> {
    public IPResourceCategoryManager(Connection con, int mid) {
        super(con, mid);
    }

    @Override
    protected IPResourceCategory getCategoryFromRs(ResultSet rs) {
        IPResourceCategory result = new IPResourceCategory();
        try {
            this.loadStandartCategoryFields(rs, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateCategory(IPResourceCategory category) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (category.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, comment, parent_id) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(3, category.getParentId());
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, category.getId());
            }
            ps.setString(1, category.getTitle());
            ps.setString(2, category.getComment());
            ps.executeUpdate();
            if (category.getId() <= 0) {
                category.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteCategory(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getTableName() {
        return "ip_resource_category";
    }
}

