/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.common.Utils;

public class DhcpOption {
    private static final Logger log = LogManager.getLogger();
    public final byte code;
    public byte[] value;
    private static final Map<String, Integer> NAME_CODES = new HashMap<String, Integer>();

    public DhcpOption(byte code, byte[] value) {
        this.code = code;
        this.value = value;
    }

    public String getValueAsString() {
        return new String(this.value, DhcpPacket.CHARSET);
    }

    public final byte getFirst() {
        return this.value.length > 0 ? this.value[0] : (byte)0;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DhcpOption other = (DhcpOption)obj;
        return this.code == other.code;
    }

    public static DhcpOption parseOption(String name, String value) {
        Integer code = null;
        try {
            code = Integer.valueOf(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (code == null && (code = NAME_CODES.get(name)) == null) {
            log.error("Can'f find option code for name: " + name);
            return null;
        }
        return DhcpOption.parseOption(code, value);
    }

    public static DhcpOption parseOption(int optionCode, String value) {
        if (value == null) {
            return null;
        }
        try {
            byte[] optionValue;
            switch (optionCode) {
                case 51: {
                    optionValue = Utils.convertIntToBytes((int)Utils.parseInt((String)value, (int)360));
                    break;
                }
                case 58: {
                    optionValue = Utils.convertIntToBytes((int)Utils.parseInt((String)value, (int)180));
                    break;
                }
                case 59: {
                    optionValue = Utils.convertIntToBytes((int)Utils.parseInt((String)value, (int)300));
                    break;
                }
                case 2: {
                    optionValue = Utils.convertIntToBytes((int)Utils.parseInt((String)value, (int)0));
                    break;
                }
                case 1: 
                case 3: 
                case 54: {
                    optionValue = Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)value));
                    break;
                }
                case 6: {
                    String[] tokens = value.split("\\s*,\\s*");
                    optionValue = new byte[tokens.length * 4];
                    int size = tokens.length;
                    for (int i = 0; i < size; ++i) {
                        byte[] address = Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)tokens[i]));
                        System.arraycopy(address, 0, optionValue, i * 4, 4);
                    }
                    break;
                }
                case 15: {
                    optionValue = value.getBytes();
                    break;
                }
                default: {
                    optionValue = Utils.stringToBytes((String)value, null);
                }
            }
            return new DhcpOption((byte)(optionCode & 0xFF), optionValue);
        }
        catch (Exception e) {
            log.error("Error DHCP option parse " + value);
            return null;
        }
    }

    static {
        NAME_CODES.put("leaseTime", Byte.toUnsignedInt((byte)51));
        NAME_CODES.put("renewalTime", Byte.toUnsignedInt((byte)58));
        NAME_CODES.put("rebindingTime", Byte.toUnsignedInt((byte)59));
        NAME_CODES.put("timeOffset", Byte.toUnsignedInt((byte)2));
        NAME_CODES.put("gate", Byte.toUnsignedInt((byte)3));
        NAME_CODES.put("router", Byte.toUnsignedInt((byte)3));
        NAME_CODES.put("serverIdentifier", Byte.toUnsignedInt((byte)54));
        NAME_CODES.put("dns", Byte.toUnsignedInt((byte)6));
        NAME_CODES.put("domainName", Byte.toUnsignedInt((byte)15));
        NAME_CODES.put("subnetMask", Byte.toUnsignedInt((byte)1));
    }
}

