/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;

public class DataLogWriter<D extends DataLog<D>>
implements Flushable {
    protected final D dataLog;
    private final WritableByteChannel writableByteChannel;
    protected long writeBufferPosition;
    protected final ByteBuffer writeBuffer;

    protected DataLogWriter(D dataLog, ByteBuffer writeBuffer) {
        this.dataLog = dataLog;
        this.writableByteChannel = ((DataLog)dataLog).writableByteChannel;
        this.writeBuffer = this.createBuffer(dataLog, writeBuffer);
    }

    protected ByteBuffer createBuffer(D dataLog, ByteBuffer readBuffer) {
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeBuffer(ByteBuffer byteBuffer) throws IOException {
        int result;
        byteBuffer.flip();
        D d = this.dataLog;
        synchronized (d) {
            this.writeBufferPosition = ((DataLog)this.dataLog).fileChannelPosition;
            result = this.writableByteChannel.write(byteBuffer);
            ((DataLog)this.dataLog).fileChannelPosition += (long)result;
        }
        byteBuffer.clear();
        return result;
    }

    @Override
    public void flush() throws IOException {
    }
}

