/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CopyOnWriteSetMap<K, V> {
    private final int initialSetCapacity;
    private final ConcurrentMap<K, Holder<V>> map;

    public CopyOnWriteSetMap(int initialCapacity, int initialSetCapacity) {
        this.initialSetCapacity = initialSetCapacity;
        this.map = new ConcurrentHashMap<K, Holder<V>>(initialCapacity);
    }

    public Set<V> get(K key) {
        Holder holder = (Holder)this.map.get(key);
        return holder != null ? holder.unmodifiable : null;
    }

    public boolean add(K key, V value) {
        while (true) {
            Holder<Object> newHolder;
            Holder oldHolder;
            if ((oldHolder = (Holder)this.map.get(key)) != null) {
                newHolder = new Holder(new HashSet(oldHolder.value));
                if (newHolder.value.add(value)) {
                    if (!this.map.replace(key, oldHolder, newHolder)) continue;
                    return true;
                }
                return false;
            }
            newHolder = new Holder(new HashSet(this.initialSetCapacity));
            newHolder.value.add(value);
            if (this.map.putIfAbsent(key, newHolder) == null) break;
        }
        return true;
    }

    public boolean remove(K key, V value) {
        block2: {
            Holder oldHolder;
            Holder newHolder;
            do {
                if ((oldHolder = (Holder)this.map.get(key)) == null) {
                    return false;
                }
                newHolder = new Holder(new HashSet(oldHolder.value));
                if (!newHolder.value.remove(value)) break block2;
            } while (!(newHolder.value.size() == 0 ? this.map.remove(key, oldHolder) : this.map.replace(key, oldHolder, newHolder)));
            return true;
        }
        return false;
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return new AbstractSet<Map.Entry<K, Set<V>>>(){
            final Set<Map.Entry<K, Holder<V>>> set;
            {
                this.set = CopyOnWriteSetMap.this.map.entrySet();
            }

            @Override
            public Iterator<Map.Entry<K, Set<V>>> iterator() {
                final Iterator iterator = this.set.iterator();
                return new Iterator<Map.Entry<K, Set<V>>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Set<V>> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new Map.Entry<K, Set<V>>(){

                            @Override
                            public K getKey() {
                                return entry.getKey();
                            }

                            @Override
                            public Set<V> getValue() {
                                return ((Holder)entry.getValue()).unmodifiable;
                            }

                            @Override
                            public Set<V> setValue(Set<V> value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.set.size();
            }
        };
    }

    static final class Holder<V> {
        final Set<V> unmodifiable;
        final Set<V> value;

        public Holder(Set<V> value) {
            this.value = value;
            this.unmodifiable = Collections.unmodifiableSet(value);
        }
    }
}

