/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ru.bitel.common.Utils;

public class RangedLongSet
extends AbstractSet<Long> {
    protected final Range[] ranges;
    protected final int size;

    public RangedLongSet(long[] range) {
        if (range[1] < range[0]) {
            this.ranges = new Range[0];
            this.size = 0;
        } else {
            Range[] r = new Range[]{new Range(range[0], range[1], 0, (int)(range[1] - range[0]))};
            this.ranges = r;
            this.size = (int)(range[1] - range[0] + 1L);
        }
    }

    public RangedLongSet(List<long[]> ranges) {
        ArrayList<long[]> list = new ArrayList<long[]>(ranges.size());
        block0: for (long[] r : ranges) {
            if (r[1] < r[0]) continue;
            for (long[] range : list) {
                if (range[0] > r[1] || range[1] < r[0]) continue;
                range[0] = Math.min(range[0], r[0]);
                range[1] = Math.max(range[1], r[1]);
                continue block0;
            }
            list.add(new long[]{r[0], r[1]});
        }
        int rangeSize = 0;
        ArrayList<Range> result = new ArrayList<Range>(list.size());
        for (long[] range : list) {
            int dif = (int)(range[1] - range[0]);
            result.add(new Range(range[0], range[1], rangeSize, rangeSize + dif));
            rangeSize += dif + 1;
        }
        this.ranges = result.toArray(new Range[result.size()]);
        this.size = rangeSize;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int index = 0;
            private Range range;
            private Long current;
            {
                this.range = RangedLongSet.this.ranges.length > 0 ? RangedLongSet.this.ranges[0] : null;
                this.current = RangedLongSet.this.ranges.length > 0 ? Long.valueOf(RangedLongSet.this.ranges[0].start) : null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Long next() {
                Long current = this.current;
                Long next = current + 1L;
                if (next > this.range.end) {
                    if (++this.index < RangedLongSet.this.ranges.length) {
                        this.range = RangedLongSet.this.ranges[this.index];
                        next = this.range.start;
                    } else {
                        next = null;
                    }
                }
                this.current = next;
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        block3: {
            block2: {
                if (!(o instanceof Long)) break block2;
                Long i = (Long)o;
                for (Range r : this.ranges) {
                    if (i < r.start || i > r.end) continue;
                    return true;
                }
                break block3;
            }
            if (!(o instanceof Integer)) break block3;
            Integer i = (Integer)o;
            for (Range r : this.ranges) {
                if ((long)i.intValue() < r.start || (long)i.intValue() > r.end) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Long get(int index) {
        for (Range r : this.ranges) {
            if (index < r.indexStart || index > r.indexEnd) continue;
            return r.start + (long)(index - r.indexStart);
        }
        return null;
    }

    public Long next(int index, Set<Long> ... excepts) {
        List<Long> result = this.freeList(index, 1, excepts);
        return result.size() > 0 ? result.get(0) : null;
    }

    public List<Long> freeList(int index, int count, Set<Long> ... excepts) {
        return this.freeList(index, count, Long.MIN_VALUE, Long.MAX_VALUE, excepts);
    }

    public List<Long> freeList(int index, int count, long min, long max, Set<Long> ... excepts) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        int i = index;
        for (Range r : this.ranges) {
            i = this.findFreeInRange(count, min, max, resultList, i, r, excepts);
        }
        if (resultList.size() == count) {
            return resultList;
        }
        i = 0;
        for (Range r : this.ranges) {
            if (r.indexStart >= index) continue;
            this.findFreeInRange(count, min, max, resultList, i, r, excepts);
        }
        return resultList;
    }

    private int findFreeInRange(int count, long min, long max, List<Long> resultList, int i, Range r, Set<Long> ... excepts) {
        long result = r.start + (long)(i - r.indexStart);
        while (i >= r.indexStart && i <= r.indexEnd) {
            boolean isInExcept = false;
            for (Set<Long> except : excepts) {
                if (!except.contains(result)) continue;
                isInExcept = true;
                break;
            }
            if (!(isInExcept || min != 0L && result < min || max != 0L && result > max)) {
                resultList.add(result);
            }
            if (resultList.size() == count) {
                return i;
            }
            ++i;
            ++result;
        }
        return i;
    }

    public List<Long> freeList(int index, int count, String lastNumberDigit, Set<Long> ... excepts) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        long div = 1L;
        for (int i = 0; i < lastNumberDigit.length(); ++i) {
            div *= 10L;
        }
        long lastDigit = Utils.parseLong(lastNumberDigit);
        int i = index;
        for (Range r : this.ranges) {
            i = this.findFreeLastInRange(count, div, lastDigit, resultList, i, r, excepts);
        }
        if (resultList.size() == count) {
            return resultList;
        }
        i = 0;
        for (Range r : this.ranges) {
            if (r.indexStart >= index) continue;
            this.findFreeLastInRange(count, div, lastDigit, resultList, i, r, excepts);
        }
        return resultList;
    }

    private int findFreeLastInRange(int count, long div, long lastDigit, List<Long> resultList, int i, Range r, Set<Long> ... excepts) {
        long result = r.start + (long)(i - r.indexStart);
        while (i >= r.indexStart && i <= r.indexEnd) {
            boolean isInExcept = false;
            for (Set<Long> except : excepts) {
                if (!except.contains(result)) continue;
                isInExcept = true;
                break;
            }
            if (!isInExcept && result % div == lastDigit) {
                resultList.add(result);
            }
            if (resultList.size() == count) {
                return i;
            }
            ++i;
            ++result;
        }
        return i;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("RangeLongSet [");
        for (Range range : this.ranges) {
            result.append(range.start);
            result.append(" - ");
            result.append(range.end);
            result.append(", ");
            result.append(range.indexStart);
            result.append(", ");
            result.append(range.indexEnd);
            result.append("; ");
        }
        result.append("], size: ");
        result.append(this.size);
        return result.toString();
    }

    public static RangedLongSet parseString(String input) {
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        block4: for (String rr : input.split(",")) {
            long start;
            long end;
            String[] r = rr.split("-");
            switch (r.length) {
                case 1: {
                    start = end = Utils.parseLong(r[0]);
                    break;
                }
                case 2: {
                    start = Utils.parseLong(r[0]);
                    end = Utils.parseLong(r[1]);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ranges.add(new long[]{start, end});
        }
        return new RangedLongSet(ranges);
    }

    private static class Range {
        final long start;
        final long end;
        final int indexStart;
        final int indexEnd;

        public Range(long start, long end, int indexStart, int indexEnd) {
            this.start = start;
            this.end = end;
            this.indexStart = indexStart;
            this.indexEnd = indexEnd;
        }
    }
}

