/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.log.server.event;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.common.SerialUtils;

@XmlRootElement
@EventType(deliveryMode=1)
public class RequestLogGetEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(RequestLogGetEvent.class);
    private final int applicationId;
    @XmlAttribute
    private final int deviceId;
    private final List<ConnectionLogEntry> logEntryList;
    private List<LogEntryResult> logEntryResultList;

    protected RequestLogGetEvent() {
        this.deviceId = -1;
        this.applicationId = -1;
        this.logEntryList = null;
    }

    public RequestLogGetEvent(int moduleId, int deviceId, int applicationId, List<ConnectionLogEntry> logEntryList) {
        super(moduleId, CONTRACT_GLOBAL, 0);
        this.deviceId = deviceId;
        this.applicationId = applicationId;
        this.logEntryList = logEntryList;
    }

    public RequestLogGetEvent(int moduleId, int deviceId, ConnectionLogEntry entry) {
        super(moduleId, CONTRACT_GLOBAL, 0);
        this.deviceId = deviceId;
        this.applicationId = entry.getApplicationId();
        ArrayList<ConnectionLogEntry> logEntryList = new ArrayList<ConnectionLogEntry>();
        logEntryList.add(entry);
        this.logEntryList = logEntryList;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public List<ConnectionLogEntry> getLogEntryList() {
        return this.logEntryList;
    }

    public List<LogEntryResult> getLogEntryResultList() {
        return this.logEntryResultList;
    }

    public void setLogEntryResultList(List<LogEntryResult> logEntryResultList) {
        this.logEntryResultList = logEntryResultList;
    }

    public int getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("applicationId", this.applicationId);
    }

    public static class LogEntryResult {
        private int id;
        private long millis;
        private String data;

        public LogEntryResult() {
        }

        public LogEntryResult(int id, long millis, String data) {
            this.id = id;
            this.millis = millis;
            this.data = data;
        }

        @XmlAttribute
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @XmlAttribute
        public long getMillis() {
            return this.millis;
        }

        public void setMillis(long millis) {
            this.millis = millis;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

