/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.tlv;

import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.network.tlv.TlvInfo;

public class Tlv<I extends TlvInfo<?, V, ?>, V> {
    public final I info;
    protected final int length;
    protected final ByteBuffer data;
    protected V value = null;

    public Tlv(I info, ByteBuffer data) {
        this.info = info;
        this.length = data.capacity();
        this.data = data;
    }

    public Tlv(I info, byte[] data) {
        this.info = info;
        this.length = data.length;
        this.data = ByteBuffer.wrap(data);
    }

    public Tlv(I info, V value) {
        this.info = info;
        ByteBuffer data = ((TlvInfo)info).wrapValue(value);
        this.length = data.capacity();
        this.data = data;
        this.value = value;
    }

    public Tlv(I info, ByteBuffer data, V value) {
        this.info = info;
        this.length = data.capacity();
        this.data = data;
        this.value = value;
    }

    public ByteBuffer getData() {
        this.data.clear();
        return this.data.asReadOnlyBuffer();
    }

    public byte[] getDataAsByteArray() {
        byte[] result = new byte[this.data.capacity()];
        this.data.get(result);
        this.data.rewind();
        return result;
    }

    public int getLength() {
        return this.length;
    }

    public V getValue() {
        if (this.value == null) {
            this.value = ((TlvInfo)this.info).unwrapValue(this.data);
        }
        return this.value;
    }
}

