/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.reports;

import java.awt.BasicStroke;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public abstract class ChartCustomizer {
    public abstract void customize(JFreeChart var1);

    public static class Area2
    extends AbstractJRChartCustomizer {
        @Override
        public void customize(JFreeChart jfreechart) {
            XYAreaRenderer2 renderer = new XYAreaRenderer2();
            renderer.setURLGenerator(jfreechart.getXYPlot().getRenderer().getURLGenerator());
            jfreechart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
    }

    public static class Area
    extends AbstractJRChartCustomizer {
        @Override
        public void customize(JFreeChart jfreechart) {
            XYAreaRenderer renderer = new XYAreaRenderer(4);
            renderer.setURLGenerator(jfreechart.getXYPlot().getRenderer().getURLGenerator());
            jfreechart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
    }

    public static class Step
    extends AbstractJRChartCustomizer {
        @Override
        public void customize(JFreeChart jfreechart) {
            XYStepRenderer renderer = new XYStepRenderer();
            renderer.setURLGenerator(jfreechart.getXYPlot().getRenderer().getURLGenerator());
            jfreechart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
    }

    public static class Bold
    extends AbstractJRChartCustomizer {
        @Override
        public void customize(JFreeChart jfreechart) {
            XYItemRenderer renderer = jfreechart.getXYPlot().getRenderer();
            int size = jfreechart.getXYPlot().getSeriesCount();
            for (int i = 0; i < size; ++i) {
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
            }
        }
    }

    public static class Bar
    extends AbstractJRChartCustomizer {
        @Override
        public void customize(JFreeChart jfreechart) {
            XYBarRenderer renderer = new XYBarRenderer();
            renderer.setURLGenerator(jfreechart.getXYPlot().getRenderer().getURLGenerator());
            jfreechart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
    }

    private static abstract class AbstractJRChartCustomizer
    extends ChartCustomizer
    implements JRChartCustomizer {
        private AbstractJRChartCustomizer() {
        }

        public void customize(JFreeChart jfreechart, JRChart jrchart) {
            this.customize(jfreechart);
        }
    }
}

