/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.scheme;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;

public class ViewSelectedOnSchemeDialogPanel
extends JPanel {
    private static final GridBagConstraints constraints = new GridBagConstraints(0, -1, 0, 0, 1.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 3, 3);

    protected ViewSelectedOnSchemeDialogPanel() {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 400;
        return dimension;
    }

    protected void viewDialog(BotDialog dialog) {
        this.removeAll();
        BGSwingUtilites.wrapBorder((JPanel)this, (String)("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0430: " + dialog.getTitle()));
        if (Utils.isEmptyCollection((Collection)dialog.getDialogElements())) {
            return;
        }
        ArrayList<BotDialogElement> buttons = new ArrayList<BotDialogElement>();
        for (BotDialogElement element : dialog.getDialogElements()) {
            if (element.getElementType().equals((Object)BotDialogElementType.BUTTON)) {
                buttons.add(element);
                continue;
            }
            JComponent component = null;
            switch (element.getElementType()) {
                case TEXT: {
                    JTextArea textArea = new JTextArea();
                    textArea.setLineWrap(true);
                    textArea.setEditable(false);
                    textArea.setText(element.getJSONConfig().optString("text"));
                    component = textArea;
                    break;
                }
                case LINK: {
                    String text = element.getJSONConfig().optString("text");
                    component = new JLabel("<html><u>" + text + "</u></html>");
                    break;
                }
                case ATTACHMENT: {
                    component = this.makeAttachmentPanel(element);
                }
            }
            if (component == null) continue;
            ViewSelectedOnSchemeDialogPanel.constraints.gridheight = 1;
            this.add((Component)component, constraints);
        }
        if (Utils.notEmptyCollection(buttons)) {
            this.add((Component)this.buildButtonsToPanel(buttons), new GridBagConstraints(0, -1, 1, 0, 0.0, 1.0, 18, 0, new Insets(3, 3, 3, 3), 3, 3));
        }
        this.setVisible(true);
    }

    private JPanel makeAttachmentPanel(BotDialogElement element) {
        JPanel attachmentPanel = new JPanel(new FlowLayout());
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(ClientUtils.getIcon((String)"src_nojava"));
        JLabel attachmentFileTitle = new JLabel(element.getJSONConfig().optString("attachmentFileTitle"));
        attachmentPanel.add(imageLabel);
        attachmentPanel.add(attachmentFileTitle);
        return attachmentPanel;
    }

    private JPanel buildButtonsToPanel(List<BotDialogElement> buttons) {
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        int gridX = 0;
        int gridY = 0;
        for (BotDialogElement elementBtn : buttons) {
            String text = elementBtn.getJSONConfig().optString("text");
            JButton button = new JButton(text);
            button.setEnabled(false);
            panel.add((Component)button, constraints);
            if (++gridX == 2) {
                gridX = 0;
                constraints.gridy = ++gridY;
            }
            constraints.gridx = gridX;
        }
        return panel;
    }
}

