/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLink;
import ru.bitel.common.TimeUtils;

public class ServiceLinkManager {
    private int mid = -1;
    private Connection con;

    public ServiceLinkManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public List<ServiceLink> getServiceLinkList() {
        ArrayList<ServiceLink> result = new ArrayList<ServiceLink>();
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_service_" + this.mid + " ORDER BY pos";
            ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceLink sl = new ServiceLink();
                this.loadFromResultSet(rs, sl);
                result.add(sl);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ServiceLink> getServiceLinkList(int plan, int sid, Calendar date) {
        ArrayList<ServiceLink> result = new ArrayList<ServiceLink>();
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_service_" + this.mid + " WHERE plan_id=? ";
            if (sid > 0) {
                query = query + " AND sid=" + sid;
            }
            if (date != null) {
                query = query + " AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
            }
            query = query + " ORDER BY pos";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, plan);
            if (date != null) {
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceLink sl = new ServiceLink();
                this.loadFromResultSet(rs, sl);
                result.add(sl);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ServiceLink> getServiceLinkList(Calendar date, int sourceId) {
        ArrayList<ServiceLink> result = new ArrayList<ServiceLink>(100);
        if (date == null) {
            System.err.println("ipn.ServiceFinder::getServiceLinkList() date=NULL");
            return result;
        }
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_service_" + this.mid + " WHERE ( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2 >=? ) AND (source=0 OR source=?)  ORDER BY plan_id, pos";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setInt(3, sourceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceLink sl = new ServiceLink();
                this.loadFromResultSet(rs, sl);
                result.add(sl);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ServiceLink getServiceLink(int id) {
        ServiceLink result = null;
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_service_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ServiceLink();
                this.loadFromResultSet(rs, result);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateServiceLink(ServiceLink sl) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (sl.getId() <= 0) {
                query = "INSERT INTO ipn_service_" + this.mid + " ( pos, date1, date2, source, direct, addr1, addr2, port1, port2, sid, comment, iface, diff_serv, plan_id )  VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query);
                ps.setInt(14, sl.getPlanId());
            } else {
                query = "UPDATE ipn_service_" + this.mid + " SET pos=?, date1=?, date2=?, source=?, direct=?, addr1=?, addr2=?, port1=?, port2=?, sid=?, comment=?, iface=?, diff_serv=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(14, sl.getId());
            }
            ps.setInt(1, sl.getPos());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)sl.getDate1()));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)sl.getDate2()));
            ps.setInt(4, sl.getSourceId());
            ps.setInt(5, sl.getDirect());
            ps.setLong(6, sl.getAddr1());
            ps.setLong(7, sl.getAddr2());
            ps.setInt(8, sl.getPort1());
            ps.setInt(9, sl.getPort2());
            ps.setInt(10, sl.getServiceId());
            ps.setString(11, sl.getComment());
            ps.setInt(12, sl.getIface());
            ps.setString(13, sl.getDiffServString());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadFromResultSet(ResultSet rs, ServiceLink sl) throws SQLException {
        sl.setId(rs.getInt("id"));
        sl.setPos(rs.getInt("pos"));
        sl.setDate1(TimeUtils.convertDateToCalendar((Date)rs.getDate("date1")));
        sl.setDate2(TimeUtils.convertDateToCalendar((Date)rs.getDate("date2")));
        sl.setAddr1(rs.getLong("addr1"));
        sl.setAddr2(rs.getLong("addr2"));
        sl.setPort1(rs.getInt("port1"));
        sl.setPort2(rs.getInt("port2"));
        sl.setServiceId(rs.getInt("sid"));
        sl.setSourceId(rs.getInt("source"));
        sl.setDirect(rs.getInt("direct"));
        sl.setComment(rs.getString("comment"));
        sl.setIface(rs.getInt("iface"));
        sl.setPlanId(rs.getInt("plan_id"));
        sl.setDiffServString(rs.getString("diff_serv"));
    }

    public void deleteServiceLink(int id) {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "DELETE FROM ipn_service_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updatePlanLinks(int planId, List<ServiceLink> serviceLinkList) {
        try {
            String query = "DELETE FROM ipn_service_" + this.mid + " WHERE plan_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, planId);
            ps.executeUpdate();
            ps.close();
            for (ServiceLink link : serviceLinkList) {
                link.setPlanId(planId);
                this.updateServiceLink(link);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyLinks(int fromId, int toId) {
        String tableName = "ipn_service_" + this.mid;
        TableCopier copier = new TableCopier(this.con);
        HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
        valuesPairs.put("plan_id", new ColumnValue(true, (Object)toId));
        try {
            copier.copyRecord(tableName, "plan_id=" + fromId, valuesPairs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

