/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import jakarta.xml.bind.JAXBException;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.AbstractConsumer;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.common.worker.WorkerTask;

public abstract class EventWorker
extends WorkerTask<EventListenerContext>
implements EventListener<Event> {
    protected AbstractConsumer consumer;
    protected long batchWait = 5000L;
    protected long errorPause = 60000L;
    protected volatile boolean working = true;
    protected final int moduleId;
    private Object firstTask;

    protected EventWorker(int moduleId) throws BGException {
        this.moduleId = moduleId;
    }

    public synchronized void setConsumer(Class<? extends Event> clazz, String query) throws BGException {
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.consumer = EventProcessor.getInstance().newSyncConsumer(clazz, this.moduleId, 0, query);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public EventWorker(EventProcessor ep, Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws BGException {
        try {
            this.moduleId = moduleId;
            this.consumer = ep.newSyncConsumer(clazz, moduleId, pluginId, query);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public EventWorker(EventProcessor ep, String destination, int moduleId, int pluginId, String query, boolean autoAcknowledge, Class<?> ... clazz) throws BGException {
        try {
            this.moduleId = moduleId;
            this.consumer = ep.newSyncConsumer(destination, moduleId, pluginId, query, autoAcknowledge, false, 2, 4, 0L, clazz);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() throws Exception {
        while (this.working) {
            EventWorker eventWorker = this;
            synchronized (eventWorker) {
                int result = this.internalRunWorker(100L, true);
                ((EventListenerContext)this.context).recycle();
                if (result < 0 && this.errorPause > 0L) {
                    try {
                        this.getLogger().info("Execution error - waiting " + this.errorPause + "ms for next try.");
                        Thread.sleep(this.errorPause);
                    }
                    catch (InterruptedException ex) {
                        Thread.interrupted();
                        this.logError(ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int internalRunWorker(long timeout, boolean wait) {
        int result = 0;
        try {
            AbstractConsumer abstractConsumer = this.consumer;
            synchronized (abstractConsumer) {
                this.firstTask = this.poll(timeout);
                if (wait) {
                    if (this.firstTask == null) {
                        this.firstTask = this.consumer.mc.receive();
                    }
                    result = this.runWorker() ? 1 : -1;
                } else if (this.firstTask != null) {
                    result = this.runWorker() ? 1 : -1;
                }
            }
        }
        catch (Throwable ex) {
            result = -1;
            if (this.consumer.eventProcessor.syncAcknowledgeFix) {
                try {
                    this.consumer.session.recover();
                }
                catch (JMSException ex2) {
                    this.logError(ex2);
                }
            }
            this.getLogger().error(this.getClass() + ": " + ex.getMessage(), ex);
        }
        return result;
    }

    protected Object pollFirstTask() {
        Object firstTask = this.firstTask;
        if (firstTask != null) {
            this.firstTask = null;
            return firstTask;
        }
        return null;
    }

    protected Object poll(long timeout) throws BGException {
        Object firstTask = this.firstTask;
        if (firstTask != null) {
            this.firstTask = null;
            return firstTask;
        }
        try {
            return this.consumer.mc.receive(timeout);
        }
        catch (JMSException ex) {
            throw new BGException(ex);
        }
    }

    public boolean doTasks() throws BGException {
        try {
            Object task;
            while ((task = this.poll(this.batchWait)) != null) {
                if (this.internalDoTask(task)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.logError(ex);
            return false;
        }
    }

    protected boolean internalDoTask(Object task) throws JMSException, JAXBException, BGException {
        if (task instanceof Message) {
            if (!this.consumer.onMessage0((Message)task, (EventListenerContext)this.context, this)) {
                return false;
            }
        } else {
            try {
                this.doTask(task);
                ((EventListenerContext)this.context).commit();
            }
            catch (BGException ex) {
                this.logError(ex);
                return false;
            }
        }
        return true;
    }

    protected abstract boolean runWorker() throws BGException;

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.doTask(e);
    }

    public abstract Object doTask(Object var1) throws BGException;

    public void shutdown() throws BGException {
        this.working = false;
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw new BGException(e);
        }
    }
}

