/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.math.BigDecimal;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.phone.server.action.ActionMailDispatch;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.bgbilling.modules.phone.server.bean.Session;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionReportSession
extends ActionMailDispatch {
    private static final HashMap<String, Integer> paramMap = new HashMap();

    @Override
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        super.doAction();
        Thread.currentThread().setPriority(1);
        if (this.showAll) {
            this.page.setPageSize(-1);
        }
        int dest = this.getIntParameter("dest", -1);
        int serviceId = this.getIntParameter("sid", -1);
        ReportManager reportManager = new ReportManager(this.con, this.mid);
        PagedList<Session> sessionList = reportManager.getSessionList(this.cid, this.items, this.date1, this.date2, this.type, this.noFree, this.page, dest, serviceId, false);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        this.setPageAttribute(table, sessionList.page);
        table.setAttribute("count", String.valueOf(sessionList.records));
        table.setAttribute("total_number", String.valueOf(sessionList.records));
        table.setAttribute("total_cost", Utils.formatCost((BigDecimal)((Session)((Object)sessionList.total)).getSessionCost()));
        float time = ((Session)((Object)sessionList.total)).getSessionTime();
        table.setAttribute("total_time", Utils.formatSessionTime((int)((Session)((Object)sessionList.total)).getSessionTime()) + " [" + Math.round(time / 60.0f) + "]");
        time = ((Session)((Object)sessionList.total)).getSessionTimeRound();
        table.setAttribute("total_time_round", Utils.formatSessionTime((int)((Session)((Object)sessionList.total)).getSessionTimeRound()) + " [" + Math.round(time / 60.0f) + "]");
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (this.html) {
            String contentType;
            String ext;
            String xsl;
            this.request.setAttribute("contentType", (Object)"binary");
            String email = this.request.getParameter("email");
            this.rootNode.setAttribute("action", "DispatchSession");
            if (!this.csv) {
                xsl = "phone_login_sessions.xsl";
                ext = ".html";
                contentType = "text/html";
            } else {
                xsl = "phone_login_sessions_csv.xsl";
                ext = ".csv";
                contentType = "application/csv";
            }
            ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
            Contract contract = (Contract)contractDao.get(this.cid);
            contractDao.close();
            table.setAttribute("contractTitle", contract.getTitle());
            table.setAttribute("comment", contract.getComment());
            table.setAttribute("date1", TimeUtils.formatDate((Calendar)this.date1));
            table.setAttribute("date2", TimeUtils.formatDate((Calendar)this.date2));
            table.setAttribute("type", String.valueOf(this.type));
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            Iterator<Session> iter = sessionList.list.iterator();
            params.put("beans", new Iter.PublicIter(iter));
            params.put("lines", new CSVLine(iter, format));
            params.put("size", new Iter.BeanNodeList(sessionList.list.size()));
            params.put("format", format);
            String fileName = (String)(contract != null ? contract.getTitle() + "_" : "") + "session_" + this.date1.get(1) + "_" + (this.date1.get(2) + 1);
            if (Utils.isBlankString((String)email)) {
                XSLManager.getInstance().transformToResponse(this.response, xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), params, contentType, fileName + ext, this.zip);
            } else {
                XSLManager.getInstance().transformAndSend(xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), params, contentType, fileName + ext, this.zip, email, null);
                try {
                    if (this.response != null) {
                        String CHARSET = "UTF-8";
                        this.response.getOutputStream().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<data status=\"ok\"/>".getBytes("UTF-8"));
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        } else {
            for (Session session : sessionList.list) {
                Element sess = this.createElement(data, "row");
                sess.setAttribute("id", String.valueOf(session.getId()));
                sess.setAttribute("cdr_id", String.valueOf(session.getCdrId()));
                sess.setAttribute("hour", format.format((Object)session.getHour()));
                sess.setAttribute("item_id", String.valueOf(session.getClientItemId()));
                sess.setAttribute("item", session.getClientItem());
                sess.setAttribute("dest", session.getDestination());
                sess.setAttribute("dest_id", String.valueOf(session.getDestCode()));
                sess.setAttribute("session_start", format.format((Object)session.getSessionStart()));
                sess.setAttribute("session_time", Utils.formatSessionTime((int)session.getSessionTime()));
                sess.setAttribute("session_time_round", Utils.formatSessionTime((int)session.getSessionTimeRound()));
                sess.setAttribute("min_cost", Utils.formatCost((float)session.getMinCost()));
                sess.setAttribute("session_cost", Utils.formatSessionCost((BigDecimal)session.getSessionCost()));
                sess.setAttribute("from_to", session.getFromNumber164() + " / " + session.getToNumber164());
                sess.setAttribute("from164", session.getFromNumber164());
                sess.setAttribute("to164", session.getToNumber164());
                sess.setAttribute("from", session.getFromNumber());
                sess.setAttribute("to", session.getToNumber());
                sess.setAttribute("service", session.getService());
            }
        }
    }

    static {
        paramMap.put("cdr_id", 1);
        paramMap.put("item", 2);
        paramMap.put("dest", 3);
        paramMap.put("service", 4);
        paramMap.put("session_start", 5);
        paramMap.put("session_time", 6);
        paramMap.put("session_time_round", 7);
        paramMap.put("min_cost", 8);
        paramMap.put("session_cost", 9);
        paramMap.put("from_to", 10);
        paramMap.put("from", 11);
        paramMap.put("to", 12);
        paramMap.put("from164", 13);
        paramMap.put("to164", 14);
        paramMap.put("session_time_short", 15);
        paramMap.put("session_time_round_short", 16);
        paramMap.put("session_time_seconds", 17);
        paramMap.put("session_time_round_seconds", 18);
    }

    public static class CSVLine {
        private Iterator<Session> sessions;
        private final Format format;
        private int[] mask;
        private final StringBuilder sb = new StringBuilder(100);

        public CSVLine(Iterator<Session> sessions, Format format) {
            this.format = format;
            this.sessions = sessions;
        }

        public void init(String pattern) {
            String[] params = Utils.patternSemicolon.split(pattern);
            this.mask = new int[params.length];
            int i = 0;
            for (String param : params) {
                this.mask[i++] = paramMap.get(param);
            }
        }

        public void setSessions(Iterator<Session> sessions) {
            this.sessions = sessions;
        }

        public String next() {
            this.sb.setLength(0);
            Session session = this.sessions.next();
            for (int i : this.mask) {
                switch (i) {
                    case 1: {
                        this.sb.append(String.valueOf(session.getCdrId()));
                        break;
                    }
                    case 2: {
                        this.sb.append(session.getClientItem());
                        break;
                    }
                    case 3: {
                        this.sb.append(session.getDestination());
                        break;
                    }
                    case 4: {
                        this.sb.append(session.getService());
                        break;
                    }
                    case 5: {
                        this.sb.append(this.format.format(session.getSessionStart()));
                        break;
                    }
                    case 6: {
                        this.sb.append(Utils.formatSessionTime((int)session.getSessionTime()) + " [" + Math.round(session.getSessionTime() / 60) + "]");
                        break;
                    }
                    case 7: {
                        this.sb.append(Utils.formatSessionTime((int)session.getSessionTimeRound()) + " [" + Math.round(session.getSessionTimeRound() / 60) + "]");
                        break;
                    }
                    case 8: {
                        this.sb.append(Utils.formatCost((float)session.getMinCost()));
                        break;
                    }
                    case 9: {
                        this.sb.append(session.getSessionCost().toPlainString());
                        break;
                    }
                    case 10: {
                        this.sb.append(session.getFromNumber164());
                        this.sb.append(" / ");
                        this.sb.append(session.getToNumber164());
                        break;
                    }
                    case 11: {
                        this.sb.append(session.getFromNumber());
                        break;
                    }
                    case 12: {
                        this.sb.append(session.getToNumber());
                        break;
                    }
                    case 13: {
                        this.sb.append(session.getFromNumber164());
                        break;
                    }
                    case 14: {
                        this.sb.append(session.getToNumber164());
                        break;
                    }
                    case 15: {
                        this.sb.append(CSVLine.formatSessionTimeShort(session.getSessionTime()));
                        break;
                    }
                    case 16: {
                        this.sb.append(CSVLine.formatSessionTimeShort(session.getSessionTimeRound()));
                        break;
                    }
                    case 17: {
                        this.sb.append(Utils.formatSessionTime((int)session.getSessionTime()));
                        break;
                    }
                    case 18: {
                        this.sb.append(Utils.formatSessionTime((int)session.getSessionTimeRound()));
                    }
                }
                this.sb.append(';');
            }
            return this.sb.toString();
        }

        private static String formatSessionTimeShort(int value) {
            StringBuilder buf = new StringBuilder();
            if (value / 3600 < 10) {
                buf.append('0');
            }
            buf.append(value / 3600);
            buf.append(':');
            if (value % 3600 / 60 < 10) {
                buf.append('0');
            }
            buf.append(value % 3600 / 60);
            buf.append(':');
            if (value % 60 < 10) {
                buf.append('0');
            }
            buf.append(value % 60);
            return buf.toString();
        }
    }
}

