/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;

public class TvDeviceTypeDao
extends DeviceTypeDao<TvDeviceType> {
    public TvDeviceTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "tv_device_type");
    }

    protected TvDeviceType newDeviceType() {
        return new TvDeviceType();
    }

    protected TvDeviceType getFromRS(ResultSet rs) throws SQLException, BGException {
        TvDeviceType result = new TvDeviceType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setDeviceEntitySpecId(rs.getInt("entitySpecId"));
        result.setComment(rs.getString("comment"));
        result.setSaHandlerClass(rs.getString("saHandlerClass"));
        result.setProtocolHandlerClass(rs.getString("protocolHandlerClass"));
        result.setDeviceManagerClass(rs.getString("deviceManagerClass"));
        result.setConfig(rs.getString("config"));
        return result;
    }

    protected void updateImpl(TvDeviceType tvDeviceType) throws BGException, SQLException {
        boolean update = tvDeviceType.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET entitySpecId=?, config=?, saHandlerClass=?, protocolHandlerClass=?, deviceManagerClass=?, title=?, comment=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, tvDeviceType.getDeviceEntitySpecId());
            ps.setString(index++, tvDeviceType.getConfig());
            ps.setString(index++, tvDeviceType.getSaHandlerClass());
            ps.setString(index++, tvDeviceType.getProtocolHandlerClass());
            ps.setString(index++, tvDeviceType.getDeviceManagerClass());
            ps.setString(index++, tvDeviceType.getTitle());
            ps.setString(index++, tvDeviceType.getComment());
            if (update) {
                ps.setInt(index++, tvDeviceType.getId());
            }
            ps.executeUpdate();
            if (!update) {
                tvDeviceType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

